/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.processManagement.ExitListener;
import us.ihmc.tools.processManagement.ProcessStreamGobbler;

public abstract class ProcessSpawner {
    private final boolean killChildProcessesOnShutdown;
    private final List<ProcessStreamGobbler> streamGobblers;
    private volatile Queue<ImmutablePair<Process, String>> processes = new ConcurrentLinkedQueue<ImmutablePair<Process, String>>();
    private volatile Map<Process, ExitListener> exitListeners = new ConcurrentHashMap<Process, ExitListener>();

    public ProcessSpawner(boolean killChildProcessesOnShutdown) {
        this.killChildProcessesOnShutdown = killChildProcessesOnShutdown;
        this.streamGobblers = new ArrayList<ProcessStreamGobbler>();
        this.setupShutdownHook();
    }

    private void setupShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown, "IHMC-ProcessSpawnerShutdown"));
    }

    protected Process spawn(String name, String[] spawnString, ProcessBuilder builder, File outputFile, File errorFile, ExitListener exitListener) {
        return this.spawn(name, spawnString, builder, outputFile, errorFile, null, null, ProcessSpawner.defaultPrintingPrefix(name), exitListener);
    }

    protected Process spawn(String name, String[] spawnString, ProcessBuilder builder, PrintStream outputStream, PrintStream errorStream, ExitListener exitListener) {
        return this.spawn(name, spawnString, builder, null, null, outputStream, errorStream, ProcessSpawner.defaultPrintingPrefix(name), exitListener);
    }

    protected Process spawn(String name, String[] spawnString, ProcessBuilder builder, File outputFile, File errorFile, PrintStream outputStream, PrintStream errorStream, String processPrintingPrefix, ExitListener exitListener) {
        if (outputFile != null) {
            builder.redirectOutput(outputFile);
        }
        if (errorFile != null) {
            builder.redirectError(errorFile);
        }
        try {
            ProcessStreamGobbler processStreamGobbler;
            LogTools.trace((String)"Forking process: {}{}", (Object)System.getProperty("line.separator"), (Object)Arrays.toString(spawnString));
            Process process = builder.start();
            ImmutablePair newPair = new ImmutablePair((Object)process, (Object)name);
            this.processes.add((ImmutablePair<Process, String>)newPair);
            this.setProcessExitListener(process, exitListener);
            if (outputFile == null) {
                processStreamGobbler = new ProcessStreamGobbler(name, process, process.getInputStream(), outputStream == null ? System.out : outputStream, processPrintingPrefix);
                this.streamGobblers.add(processStreamGobbler);
                processStreamGobbler.start();
            }
            if (errorFile == null) {
                processStreamGobbler = new ProcessStreamGobbler(name, process, process.getErrorStream(), errorStream == null ? System.err : errorStream, processPrintingPrefix);
                this.streamGobblers.add(processStreamGobbler);
                processStreamGobbler.start();
            }
            this.asyncWaitForExit((ImmutablePair<Process, String>)newPair);
            return process;
        }
        catch (IOException e) {
            this.reportProcessSpawnException(errorFile, errorStream, e);
            return null;
        }
    }

    private void asyncWaitForExit(ImmutablePair<Process, String> pair) {
        ThreadTools.startAThread(() -> {
            try {
                Process process = (Process)pair.getLeft();
                process.waitFor();
                this.processes.remove(pair);
                ExitListener exitListener = this.exitListeners.get(process);
                if (exitListener != null) {
                    int exitValue = process.exitValue();
                    exitListener.exited(exitValue);
                    this.exitListeners.remove(process);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }, (String)("ProcessExitListener" + (String)pair.getRight()));
    }

    private void reportProcessSpawnException(File errorFile, PrintStream errorStream, IOException exception) {
        if (errorStream != null) {
            exception.printStackTrace(errorStream);
        }
        if (errorFile != null) {
            try {
                PrintStream ps = new PrintStream(errorFile);
                exception.printStackTrace(ps);
                ps.flush();
                ps.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static String defaultPrintingPrefix(String commandString) {
        return "[Process: " + commandString + "] ";
    }

    public void setProcessExitListener(Process process, ExitListener exitListener) {
        if (exitListener != null) {
            this.exitListeners.put(process, exitListener);
        }
    }

    public boolean hasRunningProcesses() {
        return !this.processes.isEmpty();
    }

    public void shutdown() {
        if (this.killChildProcessesOnShutdown) {
            for (ImmutablePair immutablePair : this.processes) {
                this.kill((Process)immutablePair.getLeft());
            }
            this.processes.clear();
            this.exitListeners.clear();
        }
        for (ProcessStreamGobbler processStreamGobbler : this.streamGobblers) {
            processStreamGobbler.startShutdown();
        }
        this.streamGobblers.clear();
    }

    public abstract void kill(Process var1);
}

