/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class TimerBasedOutputStream
extends OutputStream {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private CountdownTimer countdownTimer;
    private ConcurrentLinkedQueue<String> outputQueue = new ConcurrentLinkedQueue();

    public TimerBasedOutputStream(int timerPeriod, TimeUnit timeUnit) {
        this.countdownTimer = new CountdownTimer(timerPeriod, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.baos;
        synchronized (byteArrayOutputStream) {
            this.baos.write(b);
            this.countdownTimer.reset();
        }
    }

    public boolean hasNewOutput() {
        return this.outputQueue.peek() != null;
    }

    public String getString() {
        return this.outputQueue.poll();
    }

    private class CountdownTimer {
        private final Timer timer = new Timer();
        private final int period;
        private final TimeUnit timeUnit;
        private TimerTask task;

        public CountdownTimer(int period, TimeUnit timeUnit) {
            this.period = period;
            this.timeUnit = timeUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            ByteArrayOutputStream byteArrayOutputStream = TimerBasedOutputStream.this.baos;
            synchronized (byteArrayOutputStream) {
                this.task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ByteArrayOutputStream byteArrayOutputStream = TimerBasedOutputStream.this.baos;
                        synchronized (byteArrayOutputStream) {
                            TimerBasedOutputStream.this.outputQueue.add(TimerBasedOutputStream.this.baos.toString());
                            TimerBasedOutputStream.this.baos.reset();
                        }
                    }
                };
                this.timer.schedule(this.task, this.timeUnit.toMillis(this.period));
            }
        }

        public void reset() {
            if (this.task != null) {
                this.task.cancel();
            }
            this.start();
        }
    }
}

