/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import us.ihmc.commons.Conversions;
import us.ihmc.tools.TimerSnapshot;
import us.ihmc.tools.TimerSnapshotWithExpiration;
import us.ihmc.tools.thread.MissingThreadTools;

public class Timer {
    private double resetTime = Double.NaN;

    public void reset() {
        this.resetTime = Conversions.nanosecondsToSeconds((long)System.nanoTime());
    }

    public double getElapsedTime() {
        return Conversions.nanosecondsToSeconds((long)System.nanoTime()) - this.resetTime;
    }

    public void sleepUntilExpiration(double expirationDuration) {
        if (!Double.isNaN(this.resetTime)) {
            double expirationTime = this.resetTime + expirationDuration;
            double remainingDuration = expirationTime - Conversions.nanosecondsToSeconds((long)System.nanoTime());
            MissingThreadTools.sleepAtLeast(remainingDuration);
        }
    }

    public boolean hasBeenSet() {
        return Timer.hasBeenSet(this.getElapsedTime());
    }

    public boolean isExpired(double expirationDuration) {
        return Timer.isExpired(this.getElapsedTime(), expirationDuration);
    }

    public boolean isRunning(double expirationDuration) {
        return Timer.isRunning(this.getElapsedTime(), expirationDuration);
    }

    static boolean isRunning(double timePassedSinceReset, double expirationDuration) {
        return Timer.hasBeenSet(timePassedSinceReset) && !Timer.isExpired(timePassedSinceReset, expirationDuration);
    }

    static boolean hasBeenSet(double timePassedSinceReset) {
        return !Double.isNaN(timePassedSinceReset);
    }

    static boolean isExpired(double timePassedSinceReset, double expirationDuration) {
        return Timer.hasBeenSet(timePassedSinceReset) && timePassedSinceReset > expirationDuration;
    }

    public TimerSnapshotWithExpiration createSnapshot(double expirationDuration) {
        return new TimerSnapshotWithExpiration(this.getElapsedTime(), expirationDuration);
    }

    public TimerSnapshot createSnapshot() {
        return new TimerSnapshot(this.getElapsedTime());
    }
}

