/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;

public class RestartableThread {
    private final String name;
    private final ExceptionHandler exceptionHandler;
    private final boolean runAsDaemon;
    private final RunnableThatThrows runnable;
    private Thread thread;
    private boolean running = false;

    public RestartableThread(String name, RunnableThatThrows runnable) {
        this(name, DefaultExceptionHandler.MESSAGE_AND_STACKTRACE, false, runnable);
    }

    public RestartableThread(String name, boolean runAsDaemon, RunnableThatThrows runnable) {
        this(name, DefaultExceptionHandler.MESSAGE_AND_STACKTRACE, runAsDaemon, runnable);
    }

    public RestartableThread(String name, ExceptionHandler exceptionHandler, RunnableThatThrows runnable) {
        this(name, exceptionHandler, false, runnable);
    }

    public RestartableThread(String name, ExceptionHandler exceptionHandler, boolean runAsDaemon, RunnableThatThrows runnable) {
        this.name = name;
        this.exceptionHandler = exceptionHandler;
        this.runAsDaemon = runAsDaemon;
        this.runnable = runnable;
    }

    public void start() {
        this.running = true;
        this.thread = new Thread(() -> {
            try {
                while (this.running) {
                    ExceptionTools.handle((RunnableThatThrows)this.runnable, (ExceptionHandler)this.exceptionHandler);
                }
            }
            finally {
                this.running = false;
            }
        }, this.name);
        this.thread.setDaemon(this.runAsDaemon);
        this.thread.start();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    boolean isAlive() {
        return this.thread == null ? false : this.thread.isAlive();
    }
}

