/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.string;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import us.ihmc.commons.FormattingTools;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class StringTools {
    private static final Pattern UPPERCASE_LETTER = Pattern.compile("(?<=[a-z])[A-Z]+|[A-Z](?=[a-z])|[0-9]+");

    private StringTools() {
    }

    public static String getEveryUppercaseLetter(String string) {
        Object ret = "";
        int numberOfCharaters = string.length();
        for (int i = 0; i < numberOfCharaters; ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            char characterToAdd = string.charAt(i);
            ret = (String)ret + characterToAdd;
        }
        return ret;
    }

    public static Supplier<String> format(String message, Object ... parameters) {
        return () -> ParameterizedMessageFactory.INSTANCE.newMessage(message, parameters).getFormattedMessage();
    }

    public static Supplier<String> format3D(String message, Object ... parameters) {
        Object[] formattedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            formattedParameters[i] = parameters[i] instanceof Double ? new FormattedDouble3D((Double)parameters[i]) : parameters[i];
        }
        return StringTools.format(message, formattedParameters);
    }

    public static Supplier<String> format3SF(String message, Object ... parameters) {
        Object[] formattedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            formattedParameters[i] = parameters[i] instanceof Double ? new FormattedDouble3SF((Double)parameters[i]) : parameters[i];
        }
        return StringTools.format(message, formattedParameters);
    }

    public static String zUpPoseString(Pose3DReadOnly pose) {
        return "(" + FormattingTools.getFormattedDecimal3D((double)pose.getX()) + ", " + FormattingTools.getFormattedDecimal3D((double)pose.getY()) + ", " + FormattingTools.getFormattedDecimal3D((double)pose.getZ()) + ") yaw: " + FormattingTools.getFormattedDecimal3D((double)pose.getYaw());
    }

    public static String tupleString(Tuple3DReadOnly tuple) {
        return "(" + FormattingTools.getFormattedDecimal3D((double)tuple.getX()) + ", " + FormattingTools.getFormattedDecimal3D((double)tuple.getY()) + ", " + FormattingTools.getFormattedDecimal3D((double)tuple.getZ()) + ")";
    }

    public static String titleToSnakeCase(String titleCased) {
        return titleCased.trim().replaceAll("\\s+", "_").toLowerCase();
    }

    public static String titleToKebabCase(String titleCased) {
        return titleCased.trim().replaceAll("\\s+", "-").toLowerCase();
    }

    public static String titleToPascalCase(String titleCased) {
        String[] parts = titleCased.split("\\s+");
        StringBuilder camelCased = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            camelCased.append(StringUtils.capitalize((String)parts[i]));
        }
        return camelCased.toString();
    }

    public static String titleToCamelCase(String titleCased) {
        String[] parts = titleCased.split("\\s+");
        StringBuilder camelCased = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i == 0) {
                camelCased.append(parts[i].toLowerCase());
                continue;
            }
            camelCased.append(StringUtils.capitalize((String)parts[i]));
        }
        return camelCased.toString();
    }

    public static String pascalCaseToSentenceCase(String pascalCaseString) {
        return pascalCaseString.substring(0, 1).toUpperCase() + UPPERCASE_LETTER.matcher(pascalCaseString.substring(1)).replaceAll(matchResult -> !matchResult.group().matches("[A-Z]{2,}") ? " " + matchResult.group().toLowerCase() : " " + matchResult.group());
    }

    public static String filterOutCRLFLineEndings(String stringToFilter) {
        return stringToFilter.replaceAll("\\r\\n", "\n");
    }

    public static class FormattedDouble3D {
        private final Double number;

        public FormattedDouble3D(Double number) {
            this.number = number;
        }

        public String toString() {
            return FormattingTools.getFormattedDecimal3D((double)this.number);
        }
    }

    public static class FormattedDouble3SF {
        private final Double number;

        public FormattedDouble3SF(Double number) {
            this.number = number;
        }

        public String toString() {
            return FormattingTools.getFormattedToSignificantFigures((double)this.number, (int)3);
        }
    }
}

