/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.search.strings.fuzzySearch;

import java.util.Arrays;

public class CombinedFuzzySearchResult {
    private final CombinedFuzzySearchResultType resultType;
    private final String[] subStringMatches;
    private final String searchMatch;
    private final int fuzzyScore;

    public CombinedFuzzySearchResult(String searchMatch, CombinedFuzzySearchResultType resultType, int fuzzyScore, String ... subStringMatches) {
        this.resultType = resultType;
        this.subStringMatches = subStringMatches;
        this.searchMatch = searchMatch;
        this.fuzzyScore = fuzzyScore;
    }

    public CombinedFuzzySearchResult(String searchMatch, CombinedFuzzySearchResultType resultType, String ... subStringMatches) {
        this(searchMatch, resultType, -1, subStringMatches);
    }

    public CombinedFuzzySearchResultType getResultType() {
        return this.resultType;
    }

    public String[] getSubStringMatches() {
        return this.subStringMatches;
    }

    public String getSearchMatch() {
        return this.searchMatch;
    }

    public int getFuzzyScore() {
        return this.fuzzyScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedFuzzySearchResult that = (CombinedFuzzySearchResult)o;
        if (this.fuzzyScore != that.fuzzyScore) {
            return false;
        }
        if (this.resultType != that.resultType) {
            return false;
        }
        if (!Arrays.equals(this.subStringMatches, that.subStringMatches)) {
            return false;
        }
        return this.searchMatch.equals(that.searchMatch);
    }

    public int hashCode() {
        int result = this.resultType.hashCode();
        result = 31 * result + Arrays.hashCode(this.subStringMatches);
        result = 31 * result + this.searchMatch.hashCode();
        result = 31 * result + this.fuzzyScore;
        return result;
    }

    public static enum CombinedFuzzySearchResultType {
        FUZZY,
        REGEX,
        EXACT_SUBSTRING;

    }
}

