/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.ghostMouse;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import us.ihmc.graphicsDescription.input.mouse.MouseButton;
import us.ihmc.graphicsDescription.input.mouse.MousePressedOrReleased;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMouseButtonPressedPlaybackEvent;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMouseButtonReleasedPlaybackEvent;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMouseDelayPlaybackEvent;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMouseKeyPressPlaybackEvent;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMouseKeyReleasePlaybackEvent;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMouseMovePlaybackEvent;
import us.ihmc.tools.inputDevices.ghostMouse.GhostMousePlaybackEvent;

public class GhostMousePlayback {
    private final ArrayList<GhostMousePlaybackEvent> playbackEvents = new ArrayList();
    private final Robot awtRobot = new Robot();

    public void addPlaybackEvent(GhostMousePlaybackEvent playbackEvent) {
        this.playbackEvents.add(playbackEvent);
    }

    public void addPlaybackEvent(String playbackEventString) {
        StringTokenizer tokenizer = new StringTokenizer(playbackEventString);
        String mouseType = tokenizer.nextToken("{ ");
        GhostMousePlaybackEvent playbackEvent = null;
        if (mouseType.equals("Move")) {
            int[] coordinates = this.getCoordinates(tokenizer);
            playbackEvent = new GhostMouseMovePlaybackEvent(coordinates);
        } else if (mouseType.equals("LMouse")) {
            playbackEvent = this.getPressedOrReleasedEvent(MouseButton.LEFT, tokenizer);
        } else if (mouseType.equals("MMouse")) {
            playbackEvent = this.getPressedOrReleasedEvent(MouseButton.MIDDLE, tokenizer);
        } else if (mouseType.equals("RMouse")) {
            playbackEvent = this.getPressedOrReleasedEvent(MouseButton.RIGHT, tokenizer);
        } else if (mouseType.equals("Delay")) {
            String delayInSecondsString = tokenizer.nextToken(" }");
            double delayInSeconds = Double.parseDouble(delayInSecondsString);
            playbackEvent = new GhostMouseDelayPlaybackEvent(delayInSeconds);
        } else {
            MousePressedOrReleased pressedOrReleased = this.nextTokenDownOrUp(tokenizer);
            playbackEvent = pressedOrReleased == MousePressedOrReleased.PRESSED ? new GhostMouseKeyPressPlaybackEvent(mouseType) : new GhostMouseKeyReleasePlaybackEvent(mouseType);
        }
        if (playbackEvent == null) {
            throw new RuntimeException("Cannot parse playbackEventString = " + playbackEventString);
        }
        this.addPlaybackEvent(playbackEvent);
    }

    private GhostMousePlaybackEvent getPressedOrReleasedEvent(MouseButton mouseButton, StringTokenizer tokenizer) {
        MousePressedOrReleased pressedOrReleased = this.nextTokenDownOrUp(tokenizer);
        int[] coordinates = this.getCoordinates(tokenizer);
        if (pressedOrReleased == MousePressedOrReleased.PRESSED) {
            return new GhostMouseButtonPressedPlaybackEvent(coordinates, mouseButton);
        }
        if (pressedOrReleased == MousePressedOrReleased.RELEASED) {
            return new GhostMouseButtonReleasedPlaybackEvent(coordinates, mouseButton);
        }
        throw new RuntimeException("pressedOrReleased must be either Pressed or Released!");
    }

    private MousePressedOrReleased nextTokenDownOrUp(StringTokenizer tokenizer) {
        String mouseDownOrUp = tokenizer.nextToken(" }");
        if (mouseDownOrUp.equals("down")) {
            return MousePressedOrReleased.PRESSED;
        }
        if (mouseDownOrUp.equals("up")) {
            return MousePressedOrReleased.RELEASED;
        }
        throw new RuntimeException("Neither down nor up!");
    }

    private int[] getCoordinates(StringTokenizer tokenizer) {
        String xString = tokenizer.nextToken(" (,");
        String yString = tokenizer.nextToken(" ,)");
        int x = Integer.parseInt(xString);
        int y = Integer.parseInt(yString);
        return new int[]{x, y};
    }

    public void playback() {
        this.playback(1.0);
    }

    public void playback(double playbackSpeed) {
        for (GhostMousePlaybackEvent playbackEvent : this.playbackEvents) {
            playbackEvent.playback(this.awtRobot, playbackSpeed);
        }
    }

    public void load(String filename) {
        File file = new File(filename);
        this.load(file);
    }

    public void load(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            this.load(reader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void load(BufferedReader reader) {
        try {
            while (true) {
                String playbackEventString;
                if ((playbackEventString = reader.readLine()) == null) {
                    return;
                }
                this.addPlaybackEvent(playbackEventString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public String toString() {
        Object ret = "";
        for (GhostMousePlaybackEvent playbackEvent : this.playbackEvents) {
            ret = (String)ret + playbackEvent.toString() + "\n";
        }
        return ret;
    }
}

