/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.log.LogTools;
import us.ihmc.tools.thread.CallableAfterExecuteHandler;

public class ExceptionHandlingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final HashMap<Runnable, ExceptionHandler> afterExecuteHandlers = new HashMap();

    public ExceptionHandlingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public void execute(Runnable runnable, ExceptionHandler exceptionHandler) {
        this.afterExecuteHandlers.put(runnable, exceptionHandler);
        this.execute(runnable);
    }

    public Future<Void> submit(Runnable task, ExceptionHandler exceptionHandler) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> futureTask = this.newTaskFor(task, null);
        this.afterExecuteHandlers.put(futureTask, throwable -> {
            try {
                futureTask.get();
            }
            catch (ExecutionException executionException) {
                exceptionHandler.handleException(executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                exceptionHandler.handleException((Throwable)interruptedException);
            }
            catch (CancellationException cancellationException) {
                throw new RuntimeException("This should not be possible. If the future was cancelled it wouldn't get to afterExecute()");
            }
        });
        this.execute(futureTask);
        return futureTask;
    }

    public <V> Future<V> submit(Callable<V> task, CallableAfterExecuteHandler<V> callableAfterExecuteHandler) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture futureTask = this.newTaskFor(task);
        this.afterExecuteHandlers.put(futureTask, throwable -> {
            try {
                callableAfterExecuteHandler.handle(futureTask.get(), null);
            }
            catch (ExecutionException executionException) {
                callableAfterExecuteHandler.handle(null, executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                callableAfterExecuteHandler.handle(null, interruptedException);
            }
            catch (CancellationException cancellationException) {
                throw new RuntimeException("This should not be possible. If the future was cancelled it wouldn't get to afterExecute()");
            }
        });
        this.execute(futureTask);
        return futureTask;
    }

    public void interruptRunningAndCancelQueue() {
        List<Runnable> queuedTasks = this.shutdownNow();
        for (Runnable queuedTask : queuedTasks) {
            if (!(queuedTask instanceof Future)) continue;
            ((Future)((Object)queuedTask)).cancel(false);
        }
    }

    @Override
    protected void afterExecute(Runnable runnableFuture, Throwable throwable) {
        super.afterExecute(runnableFuture, throwable);
        try {
            ExceptionHandler handler = this.afterExecuteHandlers.remove(runnableFuture);
            if (handler != null) {
                handler.handleException(throwable);
            } else {
                LogTools.warn((String)"There were no afterExecute handlers to run.");
            }
        }
        catch (NullPointerException nullPointerException) {
            LogTools.error((String)nullPointerException.getMessage());
            nullPointerException.printStackTrace();
        }
    }
}

