/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.tools.io.WorkspaceFile;
import us.ihmc.tools.io.WorkspacePathTools;
import us.ihmc.tools.io.resources.ResourceTools;

public class WorkspaceDirectory {
    private final Class<?> classForLoading;
    private final Path workspaceDirectory;
    private final String pathNecessaryForClasspathLoading;
    private final String pathNecessaryForResourceExploring;

    public WorkspaceDirectory(String directoryNameToAssumePresent, String subsequentPathToResourceFolder) {
        this(directoryNameToAssumePresent, subsequentPathToResourceFolder, null, "");
    }

    public WorkspaceDirectory(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, Class<?> classForResourceDirectory) {
        this(directoryNameToAssumePresent, subsequentPathToResourceFolder, classForResourceDirectory, "");
    }

    public WorkspaceDirectory(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String subsequentOrAbsoluteResourcePackagePath) {
        this(directoryNameToAssumePresent, subsequentPathToResourceFolder, null, subsequentOrAbsoluteResourcePackagePath);
    }

    public WorkspaceDirectory(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, Class<?> classForResourceDirectory, String subsequentOrAbsoluteResourcePackagePath) {
        this.classForLoading = classForResourceDirectory;
        Object putTogetherResourcePath = "";
        boolean isAbsolute = subsequentOrAbsoluteResourcePackagePath.startsWith("/");
        if (!isAbsolute && classForResourceDirectory != null) {
            putTogetherResourcePath = (String)putTogetherResourcePath + classForResourceDirectory.getPackage().getName().replaceAll("\\.", "/");
            putTogetherResourcePath = (String)putTogetherResourcePath + "/";
            putTogetherResourcePath = (String)putTogetherResourcePath + subsequentOrAbsoluteResourcePackagePath;
        } else {
            putTogetherResourcePath = isAbsolute ? (String)putTogetherResourcePath + subsequentOrAbsoluteResourcePackagePath.replaceFirst("/", "") : (String)putTogetherResourcePath + subsequentOrAbsoluteResourcePackagePath;
        }
        String tempPathNecessaryForResourceExploring = this.pathNecessaryForClasspathLoading = subsequentOrAbsoluteResourcePackagePath;
        if (tempPathNecessaryForResourceExploring.startsWith("/")) {
            tempPathNecessaryForResourceExploring = tempPathNecessaryForResourceExploring.replaceFirst("/", "");
        }
        this.pathNecessaryForResourceExploring = tempPathNecessaryForResourceExploring = tempPathNecessaryForResourceExploring.replaceAll("/", ".");
        this.workspaceDirectory = WorkspacePathTools.findPathToResource(directoryNameToAssumePresent, subsequentPathToResourceFolder, (String)putTogetherResourcePath);
    }

    private WorkspaceDirectory(Class<?> classForLoading, Path workspaceDirectory, String pathNecessaryForClasspathLoading, String pathNecessaryForResourceExploring) {
        this.classForLoading = classForLoading;
        this.workspaceDirectory = workspaceDirectory;
        this.pathNecessaryForClasspathLoading = pathNecessaryForClasspathLoading;
        this.pathNecessaryForResourceExploring = pathNecessaryForResourceExploring;
    }

    public boolean isFileAccessAvailable() {
        return this.workspaceDirectory != null;
    }

    public void walkResourcesFlat(BiConsumer<String, BasicPathVisitor.PathType> pathVisitor) {
        ResourceTools.walkResourcesFlat(this.pathNecessaryForResourceExploring, pathVisitor);
    }

    public List<WorkspaceFile> queryContainedFiles() {
        ArrayList<WorkspaceFile> files = new ArrayList<WorkspaceFile>();
        ResourceTools.walkResourcesFlat(this.pathNecessaryForResourceExploring, (fileName, pathType) -> {
            if (pathType == BasicPathVisitor.PathType.FILE) {
                files.add(new WorkspaceFile(this, (String)fileName));
            }
        });
        return files;
    }

    public Path getDirectoryPath() {
        return this.workspaceDirectory;
    }

    public Class<?> getClassForLoading() {
        return this.classForLoading;
    }

    public String getPathNecessaryForClasspathLoading() {
        return this.pathNecessaryForClasspathLoading;
    }

    public String getPathNecessaryForResourceExploring() {
        return this.pathNecessaryForResourceExploring;
    }

    public WorkspaceFile file(String subsequentPathToFile) {
        return new WorkspaceFile(this, subsequentPathToFile);
    }

    public WorkspaceDirectory resolve(String subdirectory) {
        return new WorkspaceDirectory(this.classForLoading, this.workspaceDirectory, this.pathNecessaryForClasspathLoading + "/" + subdirectory, this.pathNecessaryForResourceExploring + "." + subdirectory);
    }
}

