/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.string;

import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import us.ihmc.commons.FormattingTools;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class StringTools {
    private StringTools() {
    }

    public static String getEveryUppercaseLetter(String string) {
        String ret = "";
        int numberOfCharaters = string.length();
        for (int i = 0; i < numberOfCharaters; ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            char characterToAdd = string.charAt(i);
            ret = ret + characterToAdd;
        }
        return ret;
    }

    public static Supplier<String> format(String message, Object ... parameters) {
        return () -> ParameterizedMessageFactory.INSTANCE.newMessage(message, parameters).getFormattedMessage();
    }

    public static Supplier<String> format3D(String message, Object ... parameters) {
        Object[] formattedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            formattedParameters[i] = parameters[i] instanceof Double ? new FormattedDouble((Double)parameters[i]) : parameters[i];
        }
        return StringTools.format(message, formattedParameters);
    }

    public static String zUpPoseString(Pose3DReadOnly pose) {
        return "(" + FormattingTools.getFormattedDecimal3D((double)pose.getX()) + ", " + FormattingTools.getFormattedDecimal3D((double)pose.getY()) + ", " + FormattingTools.getFormattedDecimal3D((double)pose.getZ()) + ") yaw: " + FormattingTools.getFormattedDecimal3D((double)pose.getYaw());
    }

    public static String tupleString(Tuple3DReadOnly tuple) {
        return "(" + FormattingTools.getFormattedDecimal3D((double)tuple.getX()) + ", " + FormattingTools.getFormattedDecimal3D((double)tuple.getY()) + ", " + FormattingTools.getFormattedDecimal3D((double)tuple.getZ()) + ")";
    }

    public static class FormattedDouble {
        private final Double number;

        public FormattedDouble(Double number) {
            this.number = number;
        }

        public String toString() {
            return FormattingTools.getFormattedDecimal3D((double)this.number);
        }
    }
}

