/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.reflect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.tools.string.StringAndRegularExpressionMatcher;

public class StringFieldMatcher {
    private final LinkedHashMap<Class<?>, ArrayList<ImmutablePair<Field, StringAndRegularExpressionMatcher>>> fieldsToMatch = new LinkedHashMap();

    public void addStringFieldToMatchRegularExpression(Class<?> type, Field field, String regularExpressionToMatch) {
        StringAndRegularExpressionMatcher matcher = new StringAndRegularExpressionMatcher();
        matcher.addRegularExpression(regularExpressionToMatch);
        this.addStringFieldToMatch(type, field, matcher);
    }

    public void addStringFieldToMatchExactly(Class<?> type, Field field, String stringToMatch) {
        this.addStringFieldToMatchExactly(type, field, stringToMatch, true);
    }

    public void addStringFieldToMatchExactly(Class<?> type, Field field, String stringToMatch, boolean caseSensitive) {
        StringAndRegularExpressionMatcher matcher = new StringAndRegularExpressionMatcher();
        matcher.addExactStringToMatch(stringToMatch);
        this.addStringFieldToMatch(type, field, matcher);
    }

    public void addStringFieldToMatch(Class<?> type, Field field, StringAndRegularExpressionMatcher matcher) {
        field.setAccessible(true);
        ArrayList<Object> list = this.fieldsToMatch.get(type);
        if (list == null) {
            list = new ArrayList();
            this.fieldsToMatch.put(type, list);
        }
        ImmutablePair pair = new ImmutablePair((Object)field, (Object)matcher);
        list.add((ImmutablePair<Field, StringAndRegularExpressionMatcher>)pair);
    }

    public boolean matches(Object objectToTest) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<ImmutablePair<Field, StringAndRegularExpressionMatcher>> pairs = this.fieldsToMatch.get(objectToTest.getClass());
        if (pairs == null) {
            return false;
        }
        for (ImmutablePair<Field, StringAndRegularExpressionMatcher> pair : pairs) {
            String objectsFieldStringValue;
            Field field = (Field)pair.getLeft();
            StringAndRegularExpressionMatcher matcher = (StringAndRegularExpressionMatcher)pair.getRight();
            if (!matcher.matches(objectsFieldStringValue = (String)field.get(objectToTest))) continue;
            return true;
        }
        return false;
    }

    public void combine(StringFieldMatcher stringFieldMatcherToCombine) {
        Set<Class<?>> classesToCombine = stringFieldMatcherToCombine.fieldsToMatch.keySet();
        for (Class<?> type : classesToCombine) {
            ArrayList<ImmutablePair<Field, StringAndRegularExpressionMatcher>> pairs = stringFieldMatcherToCombine.fieldsToMatch.get(type);
            this.addStringFieldsToMatch(type, pairs);
        }
    }

    private void addStringFieldsToMatch(Class<?> type, ArrayList<ImmutablePair<Field, StringAndRegularExpressionMatcher>> pairs) {
        for (ImmutablePair<Field, StringAndRegularExpressionMatcher> pair : pairs) {
            Field field = (Field)pair.getLeft();
            StringAndRegularExpressionMatcher matcher = (StringAndRegularExpressionMatcher)pair.getRight();
            this.addStringFieldToMatch(type, field, matcher);
        }
    }
}

