/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.thread.TypedNotification;
import us.ihmc.log.LogTools;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;

public class MissingThreadToolsTest {
    @Test
    public void testSingleScheduleThreadWithThrownException() {
        LogTools.info((String)"Begin test");
        int[] ints = new int[1];
        int queueSize = -1;
        boolean daemon = false;
        ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"Test", (boolean)daemon, (int)queueSize);
        AtomicInteger numberOfThingsThatHappened = new AtomicInteger();
        executor.execute(() -> {
            LogTools.info((String)"ints[0] = {}", (Object)ints[0]);
            LogTools.info((String)"ints[1] = {}", (Object)ints[1]);
        }, exception -> {
            ResettableExceptionHandlingExecutorService.MESSAGE_AND_TRACE_WITH_THREAD_NAME.handleException(exception);
            Assertions.assertTrue((boolean)(exception instanceof ArrayIndexOutOfBoundsException));
            numberOfThingsThatHappened.getAndIncrement();
        });
        executor.submit(() -> {
            LogTools.info((String)"ints[0] = {}", (Object)ints[0]);
            LogTools.info((String)"ints[1] = {}", (Object)ints[1]);
        }, exception -> {
            ResettableExceptionHandlingExecutorService.MESSAGE_AND_TRACE_WITH_THREAD_NAME.handleException(exception);
            Assertions.assertTrue((boolean)(exception instanceof ArrayIndexOutOfBoundsException));
            numberOfThingsThatHappened.getAndIncrement();
        });
        executor.submit(() -> {
            LogTools.info((String)"ints[0] = {}", (Object)ints[0]);
            LogTools.info((String)"ints[1] = {}", (Object)ints[1]);
            return 5;
        }, (result, exception) -> {
            ResettableExceptionHandlingExecutorService.MESSAGE_AND_TRACE_WITH_THREAD_NAME.handleException(exception);
            Assertions.assertTrue((boolean)(exception instanceof ArrayIndexOutOfBoundsException));
            numberOfThingsThatHappened.getAndIncrement();
        });
        executor.submit(() -> {
            LogTools.info((String)"ints[0] = {}", (Object)ints[0]);
            return 5;
        }, (result, exception) -> {
            Assertions.assertEquals((int)5, (Integer)result);
            numberOfThingsThatHappened.getAndIncrement();
        });
        ThreadTools.sleepSeconds((double)0.2);
        Assertions.assertEquals((int)4, (int)numberOfThingsThatHappened.get());
        executor.destroy();
    }

    @Test
    public void testOneQueued() {
        StringBuilder output = new StringBuilder();
        ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"Test", (boolean)false, (int)1);
        TypedNotification resultOne = new TypedNotification();
        TypedNotification resultTwo = new TypedNotification();
        Runnable runnableOne = () -> {
            output.append("a");
            ThreadTools.sleep((long)10L);
            resultOne.set((Object)output.toString());
        };
        Runnable runnableTwo = () -> {
            output.append("b");
            ThreadTools.sleep((long)10L);
            resultTwo.set((Object)output.toString());
        };
        executor.clearTaskQueue();
        executor.submit(runnableOne);
        executor.clearTaskQueue();
        executor.submit(runnableTwo);
        resultOne.blockingPoll();
        Assertions.assertEquals((Object)"a", (Object)resultOne.read());
        resultTwo.blockingPoll();
        Assertions.assertEquals((Object)"ab", (Object)resultTwo.read());
        executor.destroy();
    }

    @Test
    public void testSkipItemInQueue() {
        StringBuilder output = new StringBuilder();
        ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"Test", (boolean)false, (int)1);
        TypedNotification resultOne = new TypedNotification();
        TypedNotification resultTwo = new TypedNotification();
        TypedNotification resultThree = new TypedNotification();
        Runnable runnableOne = () -> {
            output.append("a");
            ThreadTools.sleep((long)10L);
            resultOne.set((Object)output.toString());
        };
        Runnable runnableTwo = () -> {
            output.append("b");
            ThreadTools.sleep((long)10L);
            resultTwo.set((Object)output.toString());
        };
        Runnable runnableThree = () -> {
            output.append("c");
            ThreadTools.sleep((long)10L);
            resultThree.set((Object)output.toString());
        };
        executor.clearTaskQueue();
        executor.submit(runnableOne);
        executor.clearTaskQueue();
        executor.submit(runnableTwo);
        executor.clearTaskQueue();
        executor.submit(runnableThree);
        resultOne.blockingPoll();
        Assertions.assertEquals((Object)"a", (Object)resultOne.read());
        resultThree.blockingPoll();
        Assertions.assertEquals((Object)"ac", (Object)resultThree.read());
        executor.destroy();
    }

    @Test
    public void testCancellableScheduledTasks() {
        ScheduledExecutorService scheduler = ThreadTools.newSingleDaemonThreadScheduledExecutor((String)"Test");
        StringBuilder output = new StringBuilder();
        ScheduledFuture<StringBuilder> scheduledFuture1 = scheduler.schedule(() -> output.append("A"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture1.cancel(false);
        scheduler.schedule(() -> output.append("B"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        ScheduledFuture<StringBuilder> scheduledFuture2 = scheduler.schedule(() -> output.append("C"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture2.cancel(false);
        ThreadTools.sleep((long)600L);
        scheduler.schedule(() -> output.append("D"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        scheduler.schedule(() -> ExceptionTools.handle(() -> {
            output.append("E");
            throw new NullPointerException();
        }, (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)600L);
        ScheduledFuture<StringBuilder> scheduledFuture3 = scheduler.schedule(() -> output.append("F"), 400L, TimeUnit.MILLISECONDS);
        ThreadTools.sleep((long)200L);
        scheduledFuture3.cancel(false);
        ThreadTools.sleep((long)600L);
        String recordedOutput = output.toString();
        Assertions.assertEquals((Object)"BDE", (Object)recordedOutput);
        LogTools.info((String)recordedOutput);
        scheduler.shutdown();
    }
}

