/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridFile;
import us.ihmc.tools.io.resources.ResourceTools;

public class HybridDirectoryTest {
    @Disabled
    @Test
    public void testConstructors() {
        Path dotIHMC = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ihmc");
        String openRobotics = "ihmc-open-robotics-software";
        String subsequentPathToResourceFolder = "ihmc-java-toolkit/src/test/resources";
        HybridDirectory directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, "/");
        LogTools.info((Object)directory.getWorkspaceDirectory());
        LogTools.info((Object)directory.getExternalDirectory());
        LogTools.info((Object)directory.getClassForLoading());
        LogTools.info((String)directory.getPathNecessaryForClasspathLoading());
        HybridFile file = new HybridFile(directory, "testRootResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, this.getClass(), "/");
        LogTools.info((Object)directory.getWorkspaceDirectory());
        LogTools.info((Object)directory.getExternalDirectory());
        LogTools.info((Object)directory.getClassForLoading());
        LogTools.info((String)directory.getPathNecessaryForClasspathLoading());
        file = new HybridFile(directory, "testRootResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, this.getClass());
        LogTools.info((Object)directory.getWorkspaceDirectory());
        LogTools.info((Object)directory.getExternalDirectory());
        LogTools.info((Object)directory.getClassForLoading());
        LogTools.info((String)directory.getPathNecessaryForClasspathLoading());
        file = new HybridFile(directory, "classLocatedResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        file = new HybridFile(directory, "subsequent/classSubsequentResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, this.getClass(), "/root");
        LogTools.info((Object)directory.getWorkspaceDirectory());
        LogTools.info((Object)directory.getExternalDirectory());
        LogTools.info((Object)directory.getClassForLoading());
        LogTools.info((String)directory.getPathNecessaryForClasspathLoading());
        file = new HybridFile(directory, "relativeRootResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        file = new HybridFile(directory, "subsequent/rootSubsequentResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, this.getClass(), "subsequent");
        LogTools.info((Object)directory.getWorkspaceDirectory());
        LogTools.info((Object)directory.getExternalDirectory());
        LogTools.info((Object)directory.getClassForLoading());
        LogTools.info((String)directory.getPathNecessaryForClasspathLoading());
        file = new HybridFile(directory, "classSubsequentResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
        file = new HybridFile(directory, "purposefullyMisspelledResource.txt");
        LogTools.info((Object)file.getWorkspaceFile());
        LogTools.info((Object)file.getExternalFile());
        LogTools.info((Object)file.getClasspathResource());
    }

    @Test
    public void testReadResourcesFromJar() {
        Path dotIHMC = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ihmc");
        String openRobotics = "ihmc-open-robotics-software";
        String subsequentPathToResourceFolder = "ihmc-java-toolkit/src/test/resources";
        HybridDirectory directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, HybridDirectoryTest.class);
        for (String resource : ResourceTools.listResources((String)directory.getPathNecessaryForResourceExploring(), (String)".*")) {
            LogTools.info((String)resource);
        }
        LogTools.info((String)"Walking flat");
        TreeSet directoryNames = new TreeSet();
        TreeSet fileNames = new TreeSet();
        directory.walkResourcesFlat((path, pathType) -> {
            LogTools.info((String)"{}: {}", (Object)pathType.name(), (Object)path);
            if (pathType == BasicPathVisitor.PathType.FILE) {
                fileNames.add(path);
            } else {
                directoryNames.add(path);
            }
        });
        Assertions.assertTrue((boolean)fileNames.contains("testRootResource.txt"));
        Assertions.assertTrue((boolean)directoryNames.contains("us"));
        Assertions.assertTrue((boolean)directoryNames.contains("root"));
        directory = new HybridDirectory(dotIHMC, openRobotics, subsequentPathToResourceFolder, HybridDirectoryTest.class, "us/ihmc/tools/io");
        directoryNames.clear();
        fileNames.clear();
        directory.walkResourcesFlat((path, pathType) -> {
            LogTools.info((String)"{}: {}", (Object)pathType.name(), (Object)path);
            if (pathType == BasicPathVisitor.PathType.FILE) {
                fileNames.add(path);
            } else {
                directoryNames.add(path);
            }
        });
        Assertions.assertTrue((boolean)fileNames.contains("classLocatedResource.txt"));
        Assertions.assertTrue((boolean)directoryNames.contains("files"));
        Assertions.assertTrue((boolean)directoryNames.contains("subsequent"));
    }
}

