/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import com.annimon.stream.function.Supplier;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalField;

public final class StopWatch {
    private static final DateTimeFormatter df = new DateTimeFormatterBuilder().appendValue((TemporalField)ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue((TemporalField)ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue((TemporalField)ChronoField.SECOND_OF_MINUTE, 2).appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
    private final String id;
    private final List<TaskInfo> tasks = new LinkedList<TaskInfo>();
    private Instant start;
    private boolean running;
    private Duration totalDuration;
    private String currentTaskName;

    public StopWatch(String id) {
        this.id = id;
        this.totalDuration = Duration.ofNanos((long)0L);
    }

    public String getId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int size() {
        return this.tasks.size();
    }

    public void start(String taskName) {
        if (this.running) {
            throw new IllegalStateException(String.format("Cannot stop <%s>, since it is already running", this.id));
        }
        this.running = true;
        this.currentTaskName = taskName;
        this.start = Instant.now();
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException(String.format("Cannot stop <%s>, since it is not running", this.id));
        }
        Instant stop = Instant.now();
        Duration runTime = Duration.between((Temporal)this.start, (Temporal)stop);
        this.totalDuration = this.totalDuration.plus(runTime);
        TaskInfo lastTaskInfo = new TaskInfo(this.currentTaskName, runTime);
        this.tasks.add(lastTaskInfo);
        this.running = false;
        this.currentTaskName = null;
        this.start = null;
    }

    public Supplier<String> stringify() {
        return new Supplier<String>(){

            public String get() {
                StringBuilder buffer = new StringBuilder(1024);
                LocalTime totalDurationLocal = LocalTime.ofNanoOfDay((long)StopWatch.this.totalDuration.toNanos());
                buffer.append(String.format("Total time taken for <%s> - %s hours%n", StopWatch.this.id, totalDurationLocal.format(df)));
                for (TaskInfo task : StopWatch.this.tasks) {
                    buffer.append(String.format("-%5.1f%% - %s%n", StopWatch.this.calculatePercentage(task.getDuration(), StopWatch.this.totalDuration), task));
                }
                return buffer.toString();
            }
        };
    }

    public <V> V time(String taskName, Callable<V> callable) throws Exception {
        this.start(taskName);
        V returnValue = callable.call();
        this.stop();
        return returnValue;
    }

    private double calculatePercentage(Duration duration, Duration totalDuration) {
        long totalMillis = totalDuration.toMillis();
        if (totalMillis == 0L) {
            return 0.0;
        }
        return (double)duration.toMillis() * 100.0 / (double)totalMillis;
    }

    private static final class TaskInfo {
        private final String taskName;
        private final Duration duration;

        TaskInfo(String taskName, Duration duration) {
            this.taskName = taskName;
            this.duration = duration;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String toString() {
            LocalTime durationLocal = LocalTime.ofNanoOfDay((long)this.duration.toNanos());
            return String.format("%s - <%s>", durationLocal.format(df), this.taskName);
        }
    }
}

