/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import com.annimon.stream.Optional;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import sf.util.Color;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public class RegularExpressionColorMap {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RegularExpressionColorMap.class.getName());
    private final Map<Pattern, Color> colorMap = new HashMap<Pattern, Color>();

    public RegularExpressionColorMap() {
    }

    public RegularExpressionColorMap(Properties properties) {
        this();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> match : properties.entrySet()) {
            if (match == null) continue;
            Object key = match.getKey();
            Object value = match.getValue();
            if (key == null || value == null) continue;
            String regExpPattern = value.toString();
            String htmlColor = key.toString();
            if (!Utility.isBlank(regExpPattern) && !Utility.isBlank(htmlColor) && htmlColor.length() == 6) {
                this.put(regExpPattern, "#" + htmlColor);
                continue;
            }
            LOGGER.log(Level.CONFIG, new StringFormat("Could not add color mapping for %s = %s", regExpPattern, htmlColor));
        }
    }

    public boolean isEmpty() {
        return this.colorMap.isEmpty();
    }

    public Optional<Color> match(String value) {
        for (Pattern pattern : this.colorMap.keySet()) {
            if (!pattern.matcher(value).matches()) continue;
            return Optional.of((Object)this.colorMap.get(pattern));
        }
        return Optional.empty();
    }

    public void put(String regExpPattern, String htmlColor) {
        try {
            if (Utility.isBlank(regExpPattern)) {
                throw new IllegalArgumentException("No regular expression pattern provided");
            }
            Pattern pattern = Pattern.compile(regExpPattern, 0);
            Color color = Color.fromHexTriplet(htmlColor);
            this.colorMap.put(pattern, color);
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, new StringFormat("Could not add color mapping for %s = %s", regExpPattern, htmlColor), (Throwable)e);
        }
    }

    public void putLiteral(String literal, Color color) {
        try {
            if (Utility.isBlank(literal)) {
                throw new IllegalArgumentException("No literal key provided");
            }
            Pattern pattern = Pattern.compile(literal, 16);
            this.colorMap.put(pattern, color);
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, new StringFormat("Could not add literal color mapping for %s = %s", literal, color), (Throwable)e);
        }
    }

    public int size() {
        return this.colorMap.size();
    }

    public String toString() {
        return Objects.toString(this.colorMap);
    }
}

