/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import com.annimon.stream.Optional;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schema.TableType;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.Utility;

public final class TableTypes {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableTypes.class.getName());
    private final Collection<TableType> tableTypes;

    public TableTypes(Connection connection) {
        Objects.requireNonNull(connection, "No connection provided");
        this.tableTypes = new HashSet<TableType>();
        try (ResultSet tableTypesResults = connection.getMetaData().getTableTypes();){
            List<String> tableTypeStrings = DatabaseUtility.readResultsVector(tableTypesResults);
            for (String tableTypeString : tableTypeStrings) {
                if (Utility.isBlank(tableTypeString)) continue;
                this.tableTypes.add(new TableType(tableTypeString));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not obtain table types from connection", (Throwable)e);
        }
    }

    public String[] filterUnknown(Collection<String> tableTypeStrings) {
        if (tableTypeStrings == null) {
            return null;
        }
        if (tableTypeStrings.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> filteredTableTypes = new ArrayList<String>();
        for (String tableTypeString : tableTypeStrings) {
            Optional<TableType> tableType = this.lookupTableType(tableTypeString);
            if (!tableType.isPresent()) continue;
            filteredTableTypes.add(((TableType)tableType.get()).getTableType());
        }
        Collections.sort(filteredTableTypes);
        return filteredTableTypes.toArray(new String[filteredTableTypes.size()]);
    }

    public Optional<TableType> lookupTableType(String tableTypeString) {
        for (TableType tableType : this.tableTypes) {
            if (!tableType.isEqualTo(tableTypeString)) continue;
            return Optional.of((Object)tableType);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.tableTypes.toString();
    }
}

