/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schema.Column;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InclusionRuleWithRegularExpression;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.NamedObjectSort;
import schemacrawler.utility.Query;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class QueryUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(QueryUtility.class.getName());

    public static ResultSet executeAgainstSchema(Query query, Statement statement, InclusionRule schemaInclusionRule) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, schemaInclusionRule);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSql(statement, sql);
    }

    public static ResultSet executeAgainstTable(Query query, Statement statement, Table table, boolean isAlphabeticalSortForTableColumns) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, isAlphabeticalSortForTableColumns);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSql(statement, sql);
    }

    public static long executeForLong(Query query, Connection connection, Table table) throws SchemaCrawlerException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForLong(connection, sql);
    }

    public static Object executeForScalar(Query query, Connection connection) throws SchemaCrawlerException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForScalar(connection, sql);
    }

    public static Object executeForScalar(Query query, Connection connection, Table table) throws SchemaCrawlerException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForScalar(connection, sql);
    }

    private static String getColumnsListAsString(List<Column> columns, boolean omitLargeObjectColumns) {
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            JavaSqlType.JavaSqlTypeGroup javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup();
            if (omitLargeObjectColumns && javaSqlTypeGroup == JavaSqlType.JavaSqlTypeGroup.large_object) continue;
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getName());
        }
        return buffer.toString();
    }

    private static String getQuery(Query query) {
        return TemplatingUtility.expandTemplate(query.getQuery());
    }

    private static String getQuery(Query query, InclusionRule schemaInclusionRule) {
        String schemaInclusionPattern;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("schemas", ".*");
        if (schemaInclusionRule != null && schemaInclusionRule instanceof InclusionRuleWithRegularExpression && !Utility.isBlank(schemaInclusionPattern = ((InclusionRuleWithRegularExpression)schemaInclusionRule).getInclusionPattern().pattern())) {
            properties.put("schemas", schemaInclusionPattern);
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate(sql, properties);
        sql = TemplatingUtility.expandTemplate(sql);
        return sql;
    }

    private static String getQuery(Query query, Table table, boolean isAlphabeticalSortForTableColumns) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            NamedObjectSort columnsSort = NamedObjectSort.getNamedObjectSort(isAlphabeticalSortForTableColumns);
            List<Column> columns = table.getColumns();
            Collections.sort(columns, columnsSort);
            if (table.getSchema() != null) {
                tableProperties.put("schema", table.getSchema().getFullName());
            }
            tableProperties.put("table", table.getFullName());
            tableProperties.put("tablename", table.getName());
            tableProperties.put("columns", QueryUtility.getColumnsListAsString(columns, false));
            tableProperties.put("orderbycolumns", QueryUtility.getColumnsListAsString(columns, true));
            tableProperties.put("tabletype", table.getTableType().toString());
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate(sql, tableProperties);
        sql = TemplatingUtility.expandTemplate(sql);
        return sql;
    }

    private QueryUtility() {
    }
}

