/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Pattern;
import sf.util.SchemaCrawlerLogger;
import sf.util.Utility;

public final class Identifiers {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(Identifiers.class.getName());
    private static final Pattern isIdentifierPattern = Pattern.compile("^[\\p{Nd}\\p{L}\\p{M}_]*$");
    private static final Pattern isNumericPattern = Pattern.compile("^\\p{Nd}*$");
    private final String identifierQuoteString;
    private final Collection<String> reservedWords;

    public static Builder identifiers() {
        return new Builder();
    }

    private static boolean isIdentifier(String name) {
        if (Utility.isBlank(name)) {
            return false;
        }
        return isIdentifierPattern.matcher(name).matches();
    }

    private static boolean isNumeric(String name) {
        if (Utility.isBlank(name)) {
            return false;
        }
        return isNumericPattern.matcher(name).matches();
    }

    private Identifiers(Builder builder) {
        this.identifierQuoteString = builder.isIdentifierQuoteStringSet() ? builder.identifierQuoteString : "\"";
        this.reservedWords = builder.reservedWords;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public Collection<String> getReservedWords() {
        return new HashSet<String>(this.reservedWords);
    }

    public boolean isQuotedName(String name) {
        if (Utility.isBlank(name) || this.identifierQuoteString.isEmpty()) {
            return false;
        }
        int quoteLength = this.identifierQuoteString.length();
        return name.startsWith(this.identifierQuoteString) && name.endsWith(this.identifierQuoteString) && name.length() >= quoteLength * 2;
    }

    public boolean isReservedWord(String word) {
        return !Utility.isBlank(word) && this.reservedWords.contains(word.trim().toUpperCase());
    }

    public boolean isToBeQuoted(String name) {
        if (name == null || name.isEmpty() || this.isQuotedName(name)) {
            return false;
        }
        return Utility.containsWhitespace(name) || Identifiers.isNumeric(name) || this.containsSpecialCharacters(name) || this.isReservedWord(name);
    }

    public String nameQuotedName(String name) {
        if (Utility.isBlank(name)) {
            return name;
        }
        String unquotedName = this.unquotedName(name);
        String quotedName = this.isToBeQuoted(unquotedName) ? this.identifierQuoteString + unquotedName + this.identifierQuoteString : unquotedName;
        return quotedName;
    }

    public String unquotedName(String name) {
        if (Utility.isBlank(name)) {
            return name;
        }
        int quoteLength = this.identifierQuoteString.length();
        String unquotedName = this.isQuotedName(name) ? name.substring(quoteLength, name.length() - quoteLength) : name;
        return unquotedName;
    }

    private boolean containsSpecialCharacters(String name) {
        return !Identifiers.isIdentifier(name);
    }

    public static class Builder {
        private String identifierQuoteString;
        private final Collection<String> reservedWords = Builder.loadSql2003ReservedWords();

        private static Collection<String> loadSql2003ReservedWords() {
            HashSet<String> reservedWords = new HashSet<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Identifiers.class.getResourceAsStream("/sql2003_reserved_words.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (Utility.isBlank(line)) continue;
                    reservedWords.add(line);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not read list of SQL 2003 reserved words", (Throwable)e);
            }
            if (reservedWords.isEmpty()) {
                throw new RuntimeException("No SQL 2003 reserved words found");
            }
            return Builder.toUpperCase(reservedWords);
        }

        private static Collection<String> lookupReservedWords(DatabaseMetaData metaData) {
            String sqlKeywords = "";
            try {
                sqlKeywords = metaData.getSQLKeywords();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not retrieve SQL keywords metadata", (Throwable)e);
            }
            return Builder.toUpperCase(Arrays.asList(sqlKeywords.split(",")));
        }

        private static Collection<String> toUpperCase(Iterable<String> words) {
            HashSet<String> upperCaseWords = new HashSet<String>();
            if (words != null) {
                for (String word : words) {
                    if (Utility.isBlank(word)) continue;
                    upperCaseWords.add(word.toUpperCase());
                }
            }
            return upperCaseWords;
        }

        private Builder() {
        }

        public Identifiers build() {
            return new Identifiers(this);
        }

        public Builder withConnection(Connection connection) throws SQLException {
            String metaDataIdentifierQuoteString;
            Objects.requireNonNull(connection, "No connection provided");
            DatabaseMetaData metaData = Objects.requireNonNull(connection.getMetaData(), "No database metadata obtained");
            this.reservedWords.addAll(Builder.lookupReservedWords(metaData));
            if (!this.isIdentifierQuoteStringSet() && (metaDataIdentifierQuoteString = metaData.getIdentifierQuoteString()) != null) {
                this.identifierQuoteString = metaDataIdentifierQuoteString;
            }
            return this;
        }

        public Builder withIdentifierQuoteString(String identifierQuoteString) {
            this.identifierQuoteString = Utility.isBlank(identifierQuoteString) ? "" : identifierQuoteString;
            return this;
        }

        private boolean isIdentifierQuoteStringSet() {
            return this.identifierQuoteString != null;
        }
    }
}

