/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.function.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public class TablesReducer
implements Reducer<Table> {
    private final SchemaCrawlerOptions options;
    private final Predicate<Table> tableFilter;

    public TablesReducer(SchemaCrawlerOptions options, Predicate<Table> tableFilter) {
        this.options = Objects.requireNonNull(options);
        this.tableFilter = Objects.requireNonNull(tableFilter);
    }

    @Override
    public void reduce(Collection<? extends Table> allTables) {
        if (allTables == null) {
            return;
        }
        allTables.retainAll(this.doReduce(allTables));
        this.removeForeignKeys(allTables);
    }

    private Collection<Table> doReduce(Collection<? extends Table> allTables) {
        HashSet<Table> reducedTables = new HashSet<Table>();
        for (Table table : allTables) {
            if (!this.tableFilter.test((Object)table)) continue;
            reducedTables.add(table);
        }
        int childTableFilterDepth = this.options.getChildTableFilterDepth();
        Collection<Table> collection = this.includeRelatedTables(TableRelationshipType.child, childTableFilterDepth, reducedTables);
        int parentTableFilterDepth = this.options.getParentTableFilterDepth();
        Collection<Table> parentTables = this.includeRelatedTables(TableRelationshipType.parent, parentTableFilterDepth, reducedTables);
        HashSet<Table> keepTables = new HashSet<Table>();
        keepTables.addAll(reducedTables);
        keepTables.addAll(collection);
        keepTables.addAll(parentTables);
        for (Table table : allTables) {
            if (!this.isTablePartial(table) && keepTables.contains(table)) continue;
            this.markTableFilteredOut(table);
        }
        return keepTables;
    }

    private Collection<Table> includeRelatedTables(TableRelationshipType tableRelationshipType, int depth, Set<Table> greppedTables) {
        HashSet<Table> includedTables = new HashSet<Table>();
        includedTables.addAll(greppedTables);
        for (int i = 0; i < depth; ++i) {
            for (Table table : new HashSet<Table>(includedTables)) {
                for (Table relatedTable : table.getRelatedTables(tableRelationshipType)) {
                    if (this.isTablePartial(relatedTable)) continue;
                    includedTables.add(relatedTable);
                }
            }
        }
        return includedTables;
    }

    private boolean isTablePartial(Table table) {
        return table instanceof PartialDatabaseObject;
    }

    private void markTableFilteredOut(Table referencedTable) {
        referencedTable.setAttribute("schemacrawler.table.filtered_out", true);
        if (this.options.isGrepOnlyMatching()) {
            referencedTable.setAttribute("schemacrawler.table.no_grep_match", true);
        }
    }

    private void removeForeignKeys(Collection<? extends Table> allTables) {
        for (Table table : allTables) {
            for (ForeignKey foreignKey : table.getExportedForeignKeys()) {
                for (ForeignKeyColumnReference fkColumnRef : foreignKey) {
                    Table referencedTable = (Table)fkColumnRef.getForeignKeyColumn().getParent();
                    if (!this.isTablePartial(referencedTable) && allTables.contains(referencedTable)) continue;
                    this.markTableFilteredOut(referencedTable);
                }
            }
        }
    }
}

