/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class RoutineExtRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RoutineExtRetriever.class.getName());

    RoutineExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveRoutineInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasRoutinesSql()) {
            LOGGER.log(Level.INFO, "Not retrieving routine definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Routine definition SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving procedure definitions");
        Query routineDefinitionsSql = informationSchemaViews.getRoutinesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(routineDefinitionsSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String specificName;
                String routineName;
                String schemaName;
                String catalogName = this.nameQuotedName(results.getString("ROUTINE_CATALOG"));
                Optional<MutableRoutine> routineOptional = this.lookupRoutine(catalogName, schemaName = this.nameQuotedName(results.getString("ROUTINE_SCHEMA")), routineName = this.nameQuotedName(results.getString("ROUTINE_NAME")), specificName = this.nameQuotedName(results.getString("SPECIFIC_NAME")));
                if (!routineOptional.isPresent()) continue;
                MutableRoutine routine = (MutableRoutine)routineOptional.get();
                LOGGER.log(Level.FINER, new StringFormat("Retrieving routine information for <%s>", routineName));
                RoutineBodyType routineBodyType = results.getEnum("ROUTINE_BODY", RoutineBodyType.unknown);
                String definition = results.getString("ROUTINE_DEFINITION");
                routine.setRoutineBodyType(routineBodyType);
                routine.appendDefinition(definition);
                routine.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve routines", (Throwable)e);
        }
    }
}

