/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import schemacrawler.schema.NamedObject;
import sf.util.ObjectToString;
import sf.util.Utility;

class NamedObjectList<N extends NamedObject>
implements Serializable,
Collection<N> {
    private static final long serialVersionUID = 3257847666804142128L;
    private final Map<String, N> objects = new HashMap<String, N>();

    NamedObjectList() {
    }

    private static String makeLookupKey(NamedObject namedObject) {
        String key = namedObject == null ? null : namedObject.getLookupKey();
        return key;
    }

    private static String makeLookupKey(NamedObject namedObject, String name) {
        StringBuilder buffer = new StringBuilder(256);
        String namedObjectLookupKey = NamedObjectList.makeLookupKey(namedObject);
        if (namedObjectLookupKey != null) {
            buffer.append(namedObjectLookupKey);
        }
        if (buffer.length() > 0) {
            buffer.append('.');
        }
        buffer.append(name);
        String key = buffer.toString();
        return key;
    }

    private static String makeLookupKey(String fullName) {
        String key = fullName == null ? null : (Utility.isBlank(fullName) ? "" : fullName);
        return key;
    }

    @Override
    public boolean add(N namedObject) {
        Objects.requireNonNull(namedObject, "Cannot add a null object to the list");
        String key = NamedObjectList.makeLookupKey(namedObject);
        this.objects.put(key, namedObject);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends N> c) {
        throw new UnsupportedOperationException("Bulk operations are not supported");
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.objects.containsKey(NamedObjectList.makeLookupKey((NamedObject)object));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Iterator<N> iterator() {
        return this.values().iterator();
    }

    @Override
    public boolean remove(Object object) {
        NamedObject removedObject = (NamedObject)this.objects.remove(NamedObjectList.makeLookupKey((NamedObject)object));
        return removedObject != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (NamedObject namedObject : this) {
            if (namedObject == null || !c.contains(namedObject)) continue;
            String key = NamedObjectList.makeLookupKey(namedObject);
            this.objects.remove(key);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (NamedObject namedObject : this) {
            if (namedObject == null || c.contains(namedObject)) continue;
            String key = NamedObjectList.makeLookupKey(namedObject);
            this.objects.remove(key);
            modified = true;
        }
        return modified;
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public Object[] toArray() {
        return this.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.values().toArray(a);
    }

    public String toString() {
        return ObjectToString.toString(this.values());
    }

    Optional<N> lookup(NamedObject namedObject, String name) {
        String key = NamedObjectList.makeLookupKey(namedObject, name);
        return this.internalGet(key);
    }

    Optional<N> lookup(String fullName) {
        String key = NamedObjectList.makeLookupKey(fullName);
        return this.internalGet(key);
    }

    N remove(N namedObject) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(namedObject)));
    }

    N remove(String fullName) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(fullName)));
    }

    List<N> values() {
        ArrayList<N> all = new ArrayList<N>(this.objects.values());
        Collections.sort(all);
        return all;
    }

    private Optional<N> internalGet(String key) {
        return Optional.ofNullable(this.objects.get(key));
    }
}

