/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;

final class MutableJdbcDriverInfo
implements JdbcDriverInfo {
    private static final long serialVersionUID = 8030156654422512161L;
    private String driverName = "";
    private String driverClassName = "";
    private String driverVersion = "";
    private String connectionUrl = "";
    private boolean jdbcCompliant;
    private final Set<ImmutableJdbcDriverProperty> jdbcDriverProperties = new HashSet<ImmutableJdbcDriverProperty>();

    MutableJdbcDriverInfo() {
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public Collection<JdbcDriverProperty> getDriverProperties() {
        ArrayList<JdbcDriverProperty> properties = new ArrayList<JdbcDriverProperty>(this.jdbcDriverProperties);
        Collections.sort(properties);
        return properties;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- driver: ").append(this.getDriverName()).append(' ').append(this.getDriverVersion()).append(System.lineSeparator());
        info.append("-- driver class: ").append(this.getDriverClassName()).append(System.lineSeparator());
        info.append("-- url: ").append(this.getConnectionUrl()).append(System.lineSeparator());
        info.append("-- jdbc compliant: ").append(this.isJdbcCompliant());
        return info.toString();
    }

    void addJdbcDriverProperty(ImmutableJdbcDriverProperty jdbcDriverProperty) {
        this.jdbcDriverProperties.add(jdbcDriverProperty);
    }

    void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    void setJdbcCompliant(boolean jdbcCompliant) {
        this.jdbcCompliant = jdbcCompliant;
    }

    void setJdbcDriverClassName(String jdbcDriverClassName) {
        this.driverClassName = jdbcDriverClassName;
    }
}

