/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;
import schemacrawler.utility.CompareUtility;

class MutableIndex
extends AbstractDependantObject<Table>
implements Index {
    private static final long serialVersionUID = 4051326747138079028L;
    private final NamedObjectList<MutableIndexColumn> columns = new NamedObjectList();
    private boolean isUnique;
    private IndexType indexType = IndexType.unknown;
    private int cardinality;
    private int pages;
    private final StringBuilder definition = new StringBuilder();

    MutableIndex(Table parent, String name) {
        super(new TableReference(parent), name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null || !(obj instanceof Index)) {
            return -1;
        }
        Index that = (Index)obj;
        int compareTo = 0;
        if (compareTo == 0) {
            List<IndexColumn> thisColumns = this.getColumns();
            List<IndexColumn> thatColumns = that.getColumns();
            compareTo = CompareUtility.compareLists(thisColumns, thatColumns);
        }
        if (compareTo == 0 && this.isUnique != that.isUnique()) {
            int n = compareTo = this.isUnique ? -1 : 1;
        }
        if (compareTo == 0) {
            compareTo = this.indexType.ordinal() - that.getIndexType().ordinal();
        }
        if (compareTo == 0) {
            compareTo = super.compareTo(obj);
        }
        return compareTo;
    }

    @Override
    public final int getCardinality() {
        return this.cardinality;
    }

    @Override
    public List<IndexColumn> getColumns() {
        return new ArrayList<IndexColumn>(this.columns.values());
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public final IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public final int getPages() {
        return this.pages;
    }

    @Override
    public final IndexType getType() {
        return this.getIndexType();
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public Iterator<IndexColumn> iterator() {
        return this.getColumns().iterator();
    }

    public Optional<MutableIndexColumn> lookupColumn(String name) {
        return this.columns.lookup(this, name);
    }

    void addColumn(MutableIndexColumn column) {
        this.columns.add(column);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    final void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    final void setIndexType(IndexType indexType) {
        this.indexType = Objects.requireNonNull(indexType, "Null index type");
    }

    final void setPages(int pages) {
        this.pages = pages;
    }

    final void setUnique(boolean unique) {
        this.isUnique = unique;
    }
}

