/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.TypedObject;
import sf.util.Utility;

abstract class AbstractDatabaseObject
extends AbstractNamedObjectWithAttributes
implements DatabaseObject {
    private static final long serialVersionUID = 3099561832386790624L;
    private final Schema schema;

    AbstractDatabaseObject(Schema schema, String name) {
        super(name);
        this.schema = Objects.requireNonNull(schema, "No schema provided");
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        if (obj instanceof DatabaseObject) {
            int schemaCompareTo = this.getSchema().compareTo(((DatabaseObject)obj).getSchema());
            if (schemaCompareTo != 0) {
                return schemaCompareTo;
            }
            if (this instanceof TypedObject && obj instanceof TypedObject) {
                try {
                    int typeCompareTo = ((TypedObject)((Object)this)).getType().compareTo(((TypedObject)((Object)obj)).getType());
                    if (typeCompareTo != 0) {
                        return typeCompareTo;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AbstractDatabaseObject other = (AbstractDatabaseObject)obj;
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }

    @Override
    public String getFullName() {
        String quotedName;
        String schemaFullName;
        StringBuilder buffer = new StringBuilder(64);
        if (this.schema != null && !Utility.isBlank(schemaFullName = this.schema.getFullName())) {
            buffer.append(schemaFullName).append('.');
        }
        if (!Utility.isBlank(quotedName = this.getName())) {
            buffer.append(quotedName);
        }
        return buffer.toString();
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + super.hashCode();
        return result;
    }
}

