/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.DuplicateRemovedScheduler;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;

public class QueueScheduler
extends DuplicateRemovedScheduler
implements MonitorableScheduler {
    private final BlockingQueue<Request> queue;

    public QueueScheduler() {
        this.queue = new LinkedBlockingQueue<Request>();
    }

    public QueueScheduler(int capacity) {
        this.queue = new LinkedBlockingQueue<Request>(capacity);
    }

    @Override
    public void pushWhenNoDuplicate(Request request, Task task) {
        this.logger.trace("Remaining capacity: {}", (Object)this.queue.remainingCapacity());
        try {
            this.queue.put(request);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Request poll(Task task) {
        return (Request)this.queue.poll();
    }

    @Override
    public int getLeftRequestsCount(Task task) {
        return this.queue.size();
    }

    @Override
    public int getTotalRequestsCount(Task task) {
        return this.getDuplicateRemover().getTotalRequestsCount(task);
    }
}

