/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.ElementSelector;
import us.codecraft.webmagic.selector.HtmlNode;
import us.codecraft.webmagic.selector.Selector;

public class Html
extends HtmlNode {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Document document;

    public Html(String text) {
        try {
            this.document = Jsoup.parse((String)text);
        }
        catch (Exception e) {
            this.document = null;
            this.logger.warn("parse document error ", (Throwable)e);
        }
    }

    public Html(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    protected List<Element> getElements() {
        return Collections.singletonList(this.getDocument());
    }

    public String selectDocument(Selector selector) {
        if (selector instanceof ElementSelector) {
            ElementSelector elementSelector = (ElementSelector)((Object)selector);
            return elementSelector.select((Element)this.getDocument());
        }
        return selector.select(this.getFirstSourceText());
    }

    public List<String> selectDocumentForList(Selector selector) {
        if (selector instanceof ElementSelector) {
            ElementSelector elementSelector = (ElementSelector)((Object)selector);
            return elementSelector.selectList((Element)this.getDocument());
        }
        return selector.selectList(this.getFirstSourceText());
    }

    public static Html create(String text) {
        return new Html(text);
    }
}

