/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.http.annotation.ThreadSafe;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.Scheduler;

@ThreadSafe
public class PriorityScheduler
implements Scheduler {
    public static final int INITIAL_CAPACITY = 5;
    private Logger logger = Logger.getLogger(this.getClass());
    private BlockingQueue<Request> noPriorityQueue = new LinkedBlockingQueue<Request>();
    private PriorityBlockingQueue<Request> priorityQueuePlus = new PriorityBlockingQueue<Request>(5, new Comparator<Request>(){

        @Override
        public int compare(Request o1, Request o2) {
            return -new Long(o1.getPriority()).compareTo(o2.getPriority());
        }
    });
    private PriorityBlockingQueue<Request> priorityQueueMinus = new PriorityBlockingQueue<Request>(5, new Comparator<Request>(){

        @Override
        public int compare(Request o1, Request o2) {
            return -new Long(o1.getPriority()).compareTo(o2.getPriority());
        }
    });
    private Set<String> urls = new HashSet<String>();

    @Override
    public synchronized void push(Request request, Task task) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("push to queue " + request.getUrl()));
        }
        if (this.urls.add(request.getUrl())) {
            if (request.getPriority() == 0L) {
                this.noPriorityQueue.add(request);
            } else if (request.getPriority() > 0L) {
                this.priorityQueuePlus.put(request);
            } else {
                this.priorityQueueMinus.put(request);
            }
        }
    }

    @Override
    public synchronized Request poll(Task task) {
        Request poll = this.priorityQueuePlus.poll();
        if (poll != null) {
            return poll;
        }
        poll = (Request)this.noPriorityQueue.poll();
        if (poll != null) {
            return poll;
        }
        return this.priorityQueueMinus.poll();
    }
}

