/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups.defaultthreadgroup;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;
import us.abstracta.jmeter.javadsl.core.threadgroups.DslDefaultThreadGroup;
import us.abstracta.jmeter.javadsl.core.threadgroups.defaultthreadgroup.Stage;
import us.abstracta.jmeter.javadsl.core.util.JmeterFunction;

public class SimpleThreadGroupHelper
extends BaseThreadGroup<DslDefaultThreadGroup> {
    private static final Integer ZERO = 0;
    private final List<Stage> stages;

    public SimpleThreadGroupHelper(List<Stage> stages) {
        super((String)null, (Class<? extends JMeterGUIComponent>)ThreadGroupGui.class, Collections.emptyList());
        this.stages = stages;
    }

    @Override
    public AbstractThreadGroup buildThreadGroup() {
        Object threads = 1;
        Object iterations = 1;
        Object rampUpPeriod = null;
        Object duration = null;
        Object delay = null;
        if (!this.stages.isEmpty()) {
            Stage firstStage = this.stages.get(0);
            if (ZERO.equals(firstStage.threadCount())) {
                delay = firstStage.duration();
            } else {
                rampUpPeriod = firstStage.duration();
                threads = firstStage.threadCount();
            }
            iterations = firstStage.iterations();
            if (this.stages.size() > 1) {
                Stage secondStage = this.stages.get(1);
                threads = secondStage.threadCount();
                iterations = secondStage.iterations();
                if (ZERO.equals(firstStage.threadCount())) {
                    rampUpPeriod = secondStage.duration();
                    if (this.stages.size() > 2) {
                        Stage lastStage = this.stages.get(2);
                        duration = lastStage.duration();
                        iterations = lastStage.iterations();
                    }
                } else {
                    duration = secondStage.duration();
                }
            }
        }
        if (!(rampUpPeriod == null || Duration.ZERO.equals(rampUpPeriod) || iterations != null && duration == null)) {
            duration = duration != null ? this.sumDurations(duration, rampUpPeriod) : rampUpPeriod;
        }
        return this.buildSimpleThreadGroupFrom(threads, iterations, rampUpPeriod, duration, delay);
    }

    private Object sumDurations(Object duration, Object rampUpPeriod) {
        if (duration instanceof Duration && rampUpPeriod instanceof Duration) {
            return ((Duration)duration).plus((Duration)rampUpPeriod);
        }
        if (duration instanceof Duration) {
            duration = String.valueOf(SimpleThreadGroupHelper.durationToSeconds((Duration)duration));
        } else if (rampUpPeriod instanceof Duration) {
            rampUpPeriod = String.valueOf(SimpleThreadGroupHelper.durationToSeconds((Duration)rampUpPeriod));
        }
        return JmeterFunction.groovy(SimpleThreadGroupHelper.buildGroovySolvingIntExpression((String)duration) + " + " + SimpleThreadGroupHelper.buildGroovySolvingIntExpression((String)rampUpPeriod));
    }

    private static String buildGroovySolvingIntExpression(String expr) {
        return "(new org.apache.jmeter.engine.util.CompoundVariable('" + expr.replace("$", "#") + "'.replace('#','$')).execute() as int)";
    }

    private ThreadGroup buildSimpleThreadGroupFrom(Object threads, Object iterations, Object rampUpPeriod, Object duration, Object delay) {
        ThreadGroup ret = new ThreadGroup();
        this.setIntProperty((TestElement)ret, "ThreadGroup.num_threads", threads);
        this.setIntProperty((TestElement)ret, "ThreadGroup.ramp_time", rampUpPeriod == null ? Duration.ZERO : rampUpPeriod);
        LoopController loopController = new LoopController();
        ret.setSamplerController(loopController);
        if (duration != null) {
            loopController.setLoops(-1);
            this.setLongProperty((TestElement)ret, "ThreadGroup.duration", duration);
        } else {
            this.setIntProperty((TestElement)loopController, "LoopController.loops", iterations);
        }
        if (delay != null) {
            this.setLongProperty((TestElement)ret, "ThreadGroup.delay", delay);
        }
        if (duration != null || delay != null) {
            ret.setScheduler(true);
        }
        return ret;
    }

    private void setIntProperty(TestElement ret, String propName, Object value) {
        if (value instanceof Duration) {
            ret.setProperty(propName, (int)SimpleThreadGroupHelper.durationToSeconds((Duration)value));
        } else if (value instanceof Integer) {
            ret.setProperty(propName, ((Integer)value).intValue());
        } else {
            ret.setProperty(propName, (String)value);
        }
    }

    private void setLongProperty(TestElement ret, String propName, Object value) {
        if (value instanceof Duration) {
            ret.setProperty(propName, SimpleThreadGroupHelper.durationToSeconds((Duration)value));
        } else {
            ret.setProperty(propName, (String)value);
        }
    }

    public static class CodeBuilder
    extends MethodCallBuilder {
        public CodeBuilder(List<Method> builderMethods) {
            super(builderMethods);
        }

        @Override
        public boolean matches(MethodCallContext context) {
            return false;
        }

        @Override
        public MethodCall buildMethodCall(MethodCallContext context) {
            TestElementParamBuilder testElement = new TestElementParamBuilder(context.getTestElement());
            MethodParam.NameParam name = testElement.nameParam("Thread Group");
            MethodParam threads = testElement.intParam("ThreadGroup.num_threads");
            MethodParam rampTime = testElement.durationParam("ThreadGroup.ramp_time", Duration.ofSeconds(1L));
            MethodParam duration = testElement.durationParam("ThreadGroup.duration");
            MethodParam delay = testElement.durationParam("ThreadGroup.delay");
            MethodParam iterations = testElement.intParam("ThreadGroup.main_controller/LoopController.loops");
            if (threads instanceof MethodParam.IntParam && duration instanceof MethodParam.DurationParam && iterations instanceof MethodParam.IntParam && this.isDefaultOrZeroDuration(rampTime) && this.isDefaultOrZeroDuration(delay)) {
                return this.buildMethodCall(name, threads, this.isDefaultOrZeroDuration(duration) ? iterations : duration, new MethodParam.ChildrenParam<BaseThreadGroup.ThreadGroupChild[]>(BaseThreadGroup.ThreadGroupChild[].class));
            }
            MethodCall ret = this.buildMethodCall(name);
            if (!delay.isDefault()) {
                ret.chain("holdFor", delay);
            }
            if (!duration.isDefault()) {
                ret.chain("rampToAndHold", threads, rampTime, this.buildDurationParam(duration, rampTime));
            } else {
                ret.chain("rampTo", threads, rampTime).chain("holdIterating", iterations);
            }
            return ret;
        }

        private boolean isDefaultOrZeroDuration(MethodParam duration) {
            return duration.isDefault() || duration instanceof MethodParam.DurationParam && ((Duration)((MethodParam.DurationParam)duration).getValue()).isZero();
        }

        private MethodParam.DurationParam buildDurationParam(MethodParam duration, MethodParam rampTime) {
            if (duration instanceof MethodParam.DurationParam && rampTime instanceof MethodParam.DurationParam) {
                return new MethodParam.DurationParam(rampTime.isDefault() ? (Duration)((MethodParam.DurationParam)duration).getValue() : ((Duration)((MethodParam.DurationParam)duration).getValue()).minus((Duration)((MethodParam.DurationParam)rampTime).getValue()));
            }
            String expression = rampTime.isDefault() || rampTime instanceof MethodParam.DurationParam && ((Duration)((MethodParam.DurationParam)rampTime).getValue()).isZero() ? duration.getExpression() : JmeterFunction.groovy(SimpleThreadGroupHelper.buildGroovySolvingIntExpression(duration.getExpression()) + " - " + SimpleThreadGroupHelper.buildGroovySolvingIntExpression(rampTime.getExpression()));
            return new MethodParam.DurationParam(expression, null);
        }
    }
}

