/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kg.apc.jmeter.samplers.DummySampler;
import kg.apc.jmeter.timers.functions.TSTFeedback;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jorphan.collections.HashTree;

public class JmeterEnvironment {
    private static final String BIN_DIR = "bin";
    private static final String JMETER_PROPS_FILE_NAME = "jmeter.properties";

    public JmeterEnvironment() throws IOException {
        File homeDir = Files.createTempDirectory("jmeter-java-dsl", new FileAttribute[0]).toFile();
        homeDir.deleteOnExit();
        JMeterUtils.setJMeterHome((String)homeDir.getPath());
        File binDir = new File(homeDir, BIN_DIR);
        binDir.deleteOnExit();
        this.installConfig(binDir);
        JMeterUtils.getProperties((String)new File(binDir, JMETER_PROPS_FILE_NAME).getPath());
    }

    public void updateSearchPath(HashTree tree) {
        Set<Class<?>> classes = this.findTestElementClasses(tree);
        classes.add(EvalFunction.class);
        classes.add(TSTFeedback.class);
        classes.add(BackendListenerClient.class);
        classes.add(DummySampler.class);
        Set jarPaths = classes.stream().map(this::getClassJarPath).collect(Collectors.toSet());
        JMeterUtils.getJMeterProperties().setProperty("search_paths", String.join((CharSequence)";", jarPaths));
    }

    private Set<Class<?>> findTestElementClasses(HashTree tree) {
        HashSet ret = new HashSet();
        for (Object elem : tree.list()) {
            ret.add(elem.getClass());
            ret.addAll(this.findTestElementClasses(tree.getTree(elem)));
        }
        return ret;
    }

    private String getClassJarPath(Class<?> theClass) {
        try {
            return new File(theClass.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void installConfig(File binDir) throws IOException {
        Pattern whiteListPattern = Pattern.compile("/bin(?:/(?:report-template.*|.*\\.properties))?");
        try (FileSystem fs = FileSystems.newFileSystem(this.getClass().getResource("/bin/jmeter.properties").toURI(), Collections.emptyMap());){
            Path configBinDir = fs.getPath("/bin", new String[0]);
            for (Path p : Files.walk(configBinDir, new FileVisitOption[0])::iterator) {
                if (!whiteListPattern.matcher(p.toString()).matches()) continue;
                Path targetPath = binDir.toPath().resolve(configBinDir.relativize(p).toString());
                Files.copy(p, targetPath, new CopyOption[0]);
                targetPath.toFile().deleteOnExit();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveTree(HashTree tree, FileOutputStream output) throws IOException {
        SaveService.saveTree((HashTree)tree, (OutputStream)output);
    }

    public HashTree loadTree(File file) throws IOException {
        return SaveService.loadTree((File)file);
    }

    public void initLocale() {
        JMeterUtils.initLocale();
    }
}

