/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.listeners.DslVisualizer;

public class BuildTreeContext {
    private final BuildTreeContext parent;
    private final Map<String, Object> entries = new HashMap<String, Object>();
    private final List<TreeContextEndListener> endListeners = new ArrayList<TreeContextEndListener>();
    private final Map<DslVisualizer, Supplier<Component>> visualizers;

    public BuildTreeContext() {
        this(null, new LinkedHashMap<DslVisualizer, Supplier<Component>>());
    }

    private BuildTreeContext(BuildTreeContext parent, Map<DslVisualizer, Supplier<Component>> visualizers) {
        this.parent = parent;
        this.visualizers = visualizers;
    }

    public BuildTreeContext getParent() {
        return this.parent;
    }

    public BuildTreeContext getRoot() {
        return this.isRoot() ? this : this.parent.getRoot();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Object getEntry(String key) {
        return this.entries.get(key);
    }

    public <T> T getOrCreateEntry(String key, Supplier<T> supplier) {
        return (T)this.entries.computeIfAbsent(key, k -> supplier.get());
    }

    public void setEntry(String key, Object value) {
        this.entries.put(key, value);
    }

    public void addEndListener(TreeContextEndListener endListener) {
        this.endListeners.add(endListener);
    }

    public void addVisualizer(DslVisualizer visualizer, Supplier<Component> guiBuilder) {
        this.visualizers.put(visualizer, guiBuilder);
    }

    public Map<DslVisualizer, Supplier<Component>> getVisualizers() {
        return this.visualizers;
    }

    public void buildChild(DslTestElement child, HashTree parentTree) {
        new BuildTreeContext(this, this.visualizers).buildTreeFor(child, parentTree);
    }

    public HashTree buildTreeFor(DslTestElement element, HashTree parentTree) {
        HashTree ret = element.buildTreeUnder(parentTree, this);
        this.endListeners.forEach(l -> l.execute(this, ret));
        return ret;
    }

    public static interface TreeContextEndListener {
        public void execute(BuildTreeContext var1, HashTree var2);
    }
}

