/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.lang.reflect.Method;
import java.util.List;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;

public abstract class MethodCallBuilder {
    protected final List<Method> builderMethods;

    protected MethodCallBuilder(List<Method> builderMethods) {
        this.builderMethods = builderMethods;
    }

    public abstract boolean matches(MethodCallContext var1);

    protected abstract MethodCall buildMethodCall(MethodCallContext var1);

    protected MethodCall buildMethodCall(MethodParam<?> ... params) {
        return MethodCall.from(this.findBuilderMethod(params), params);
    }

    private Method findBuilderMethod(MethodParam<?> ... params) {
        Method ret = MethodCall.findParamsMatchingMethod(this.builderMethods.stream(), params);
        if (ret == null) {
            throw MethodCall.buildNoMatchingMethodFoundException(this.builderMethods.get(0).getName() + " builder", params);
        }
        return ret;
    }
}

