/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPConstants;
import org.apache.jmeter.protocol.http.util.HTTPConstantsInterface;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslJsr223PreProcessor;
import us.abstracta.jmeter.javadsl.core.samplers.BaseSampler;
import us.abstracta.jmeter.javadsl.http.ClientImplParam;
import us.abstracta.jmeter.javadsl.http.ContentTypeParam;
import us.abstracta.jmeter.javadsl.http.DslCacheManager;
import us.abstracta.jmeter.javadsl.http.DslCookieManager;
import us.abstracta.jmeter.javadsl.http.EncodingParam;
import us.abstracta.jmeter.javadsl.http.HttpHeaders;
import us.abstracta.jmeter.javadsl.http.JmeterUrl;

public class DslHttpSampler
extends BaseSampler<DslHttpSampler> {
    private String protocol;
    private String host;
    private String port;
    private String path;
    private String method = "GET";
    private final List<HTTPArgument> arguments = new ArrayList<HTTPArgument>();
    private final HttpHeaders headers = new HttpHeaders();
    private String body;
    private boolean multiPart;
    private final List<HTTPFileArg> files = new ArrayList<HTTPFileArg>();
    private Charset encoding;
    private boolean followRedirects = true;
    private boolean downloadEmbeddedResources;
    private HttpClientImpl clientImpl;

    public DslHttpSampler(String name, String url) {
        this(name);
        if (url == null) {
            return;
        }
        JmeterUrl parsedUrl = JmeterUrl.valueOf(url);
        this.protocol = parsedUrl.protocol();
        this.host = parsedUrl.host();
        this.port = parsedUrl.port();
        this.path = parsedUrl.path();
    }

    private DslHttpSampler(String name) {
        super(name != null ? name : "HTTP Request", HttpTestSampleGui.class);
    }

    public DslHttpSampler(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> urlSupplier) {
        this(name);
        String variableName = "PRE_PROCESSOR_URL";
        this.path = "${" + variableName + "}";
        this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)urlSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public DslHttpSampler host(String host) {
        this.host = host;
        return this;
    }

    public DslHttpSampler port(int port) {
        this.port = String.valueOf(port);
        return this;
    }

    public DslHttpSampler post(String body, ContentType contentType) {
        return this.method("POST").contentType(contentType).body(body);
    }

    public DslHttpSampler post(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier, ContentType contentType) {
        return this.method("POST").contentType(contentType).body(bodySupplier);
    }

    public DslHttpSampler method(String method) {
        this.method = method;
        return this;
    }

    public DslHttpSampler header(String name, String value) {
        this.headers.header(name, value);
        return this;
    }

    public DslHttpSampler header(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> valueSupplier) {
        String variableNamePrefix = "PRE_PROCESSOR_HEADER~";
        this.headers.header(name, "${" + variableNamePrefix + name + "}");
        return (DslHttpSampler)this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableNamePrefix + name, (String)valueSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler contentType(ContentType contentType) {
        this.headers.contentType(contentType);
        return this;
    }

    public DslHttpSampler body(String body) {
        this.body = body;
        return this;
    }

    public DslHttpSampler body(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier) {
        String variableName = "PRE_PROCESSOR_REQUEST_BODY";
        this.body = "${" + variableName + "}";
        return (DslHttpSampler)this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)bodySupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler bodyFile(String filePath) {
        this.files.add(new HTTPFileArg(filePath, "", ""));
        return this;
    }

    public DslHttpSampler param(String name, String value) {
        this.arguments.add(new HTTPArgument(name, value));
        return this;
    }

    public DslHttpSampler encodedParam(String name, String value) {
        HTTPArgument arg = new HTTPArgument(name, value);
        arg.setAlwaysEncoded(false);
        this.arguments.add(arg);
        return this;
    }

    public DslHttpSampler bodyPart(String name, String value, ContentType contentType) {
        this.multiPart = true;
        HTTPArgument arg = new HTTPArgument(name, value);
        arg.setContentType(contentType.toString());
        this.arguments.add(arg);
        return this;
    }

    public DslHttpSampler bodyFilePart(String name, String filePath, ContentType contentType) {
        this.multiPart = true;
        this.files.add(new HTTPFileArg(filePath, name, contentType.toString()));
        return this;
    }

    public DslHttpSampler encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpSampler followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public DslHttpSampler downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpSampler clientImpl(HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    public TestElement buildTestElement() {
        HTTPSamplerProxy ret = new HTTPSamplerProxy();
        if (this.protocol != null) {
            ret.setProtocol(this.protocol);
        }
        if (this.host != null) {
            ret.setDomain(this.host);
        }
        if (this.port != null) {
            ret.setProperty("HTTPSampler.port", this.port);
        }
        if (this.path != null) {
            ret.setPath(this.path);
        }
        ret.setMethod(this.method);
        ret.setArguments(this.buildArguments());
        if (this.multiPart) {
            ret.setDoMultipart(this.multiPart);
        }
        ret.setHTTPFiles(this.files.toArray(new HTTPFileArg[0]));
        if (this.encoding != null) {
            ret.setContentEncoding(this.encoding.toString());
        }
        ret.setFollowRedirects(this.followRedirects);
        ret.setUseKeepAlive(true);
        if (this.downloadEmbeddedResources) {
            ret.setImageParser(true);
            ret.setConcurrentDwn(true);
        }
        if (this.clientImpl != null) {
            ret.setImplementation(this.clientImpl.propertyValue);
        }
        return ret;
    }

    private Arguments buildArguments() {
        Arguments args = new Arguments();
        if (this.body != null) {
            HTTPArgument arg = new HTTPArgument("", this.body, false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        }
        this.arguments.forEach(arg_0 -> ((Arguments)args).addArgument(arg_0));
        return args;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        HashTree ret = super.buildTreeUnder(parent, context);
        if (!this.headers.isEmpty()) {
            context.buildChild(this.headers, ret);
        }
        new DslCookieManager().registerDependency(context);
        new DslCacheManager().registerDependency(context);
        return ret;
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<HTTPSamplerProxy> {
        public CodeBuilder(List<Method> builderMethods) {
            super(HTTPSamplerProxy.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(HTTPSamplerProxy testElement, MethodCallContext buildContext) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement);
            MethodParam.StringParam name = paramBuilder.nameParam("HTTP Request");
            MethodParam.StringParam protocol = paramBuilder.stringParam("HTTPSampler.protocol");
            MethodParam.StringParam domain = paramBuilder.stringParam("HTTPSampler.domain");
            MethodParam.IntParam port = paramBuilder.intParam("HTTPSampler.port");
            MethodParam.StringParam path = paramBuilder.stringParam("HTTPSampler.path", "/");
            MethodParam.StringParam url = this.buildUrlParam(protocol, domain, port, path);
            MethodCall ret = this.buildMethodCall(name, url);
            buildContext.findBuilder(DslCacheManager.CodeBuilder.class).registerDependency(buildContext, ret);
            buildContext.findBuilder(DslCookieManager.CodeBuilder.class).registerDependency(buildContext, ret);
            if (url == path) {
                ret.chain("protocol", protocol).chain("host", domain).chain("port", port);
            }
            this.buildRequestCall(ret, testElement, buildContext);
            return ret.chain("encoding", new EncodingParam(paramBuilder)).chain("followRedirects", this.buildFollowRedirectsParam(paramBuilder)).chain("downloadEmbeddedResources", paramBuilder.boolParam("HTTPSampler.image_parser", false)).chain("clientImpl", new ClientImplParam(paramBuilder));
        }

        private MethodParam.StringParam buildUrlParam(MethodParam.StringParam protocol, MethodParam.StringParam domain, MethodParam.IntParam port, MethodParam.StringParam path) {
            if (!domain.isDefault()) {
                return new MethodParam.StringParam((protocol.isDefault() ? "http" : (String)protocol.getValue()) + "://" + (String)domain.getValue() + (port.isDefault() ? "" : ":" + port.getValue()) + (path.isDefault() ? "" : (String)path.getValue()));
            }
            return path;
        }

        private void buildRequestCall(MethodCall ret, HTTPSamplerProxy testElem, MethodCallContext buildContext) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElem);
            HttpMethodParam method = new HttpMethodParam(paramBuilder);
            MethodCallContext headers = buildContext.removeChild(HeaderManager.class);
            String contentType = this.removeContentTypeHeader(headers);
            Arguments args = testElem.getArguments();
            if (!method.isDefault() && "POST".equals(((String)method.getValue()).toUpperCase(Locale.US)) && !testElem.getUseMultipart() && contentType != null && this.isRawBody(args)) {
                ret.chain("post", this.buildRawBody(args), new ContentTypeParam(contentType));
                this.chainHeaders(ret, headers);
                return;
            }
            ret.chain("method", method);
            if (contentType != null) {
                this.chainContentType(ret, contentType);
            }
            this.chainHeaders(ret, headers);
            if (this.isRawBody(args)) {
                ret.chain("body", this.buildRawBody(args));
            } else if (testElem.getSendFileAsPostBody()) {
                HTTPFileArg file = testElem.getHTTPFiles()[0];
                if (file.getMimeType() != null && !file.getMimeType().isEmpty()) {
                    this.chainContentType(ret, file.getMimeType());
                }
                ret.chain("bodyFile", new MethodParam.StringParam(file.getPath()));
            } else if (testElem.getUseMultipart()) {
                for (JMeterProperty prop : args) {
                    HTTPArgument arg = (HTTPArgument)prop.getObjectValue();
                    ret.chain("bodyPart", new MethodParam.StringParam(arg.getName()), new MethodParam.StringParam(arg.getValue()), new ContentTypeParam(arg.getContentType()));
                }
                for (HTTPFileArg file : testElem.getHTTPFiles()) {
                    ret.chain("bodyFilePart", new MethodParam.StringParam(file.getParamName()), new MethodParam.StringParam(file.getPath()), new ContentTypeParam(file.getMimeType()));
                }
            } else {
                for (JMeterProperty prop : args) {
                    HTTPArgument arg = (HTTPArgument)prop.getObjectValue();
                    if (arg.isAlwaysEncoded()) {
                        ret.chain("param", new MethodParam.StringParam(arg.getName()), new MethodParam.StringParam(arg.getValue()));
                        continue;
                    }
                    ret.chain("encodedParam", new MethodParam.StringParam(arg.getName()), new MethodParam.StringParam(arg.getValue()));
                }
            }
        }

        private String removeContentTypeHeader(MethodCallContext context) {
            if (context == null) {
                return null;
            }
            String headerName = "Content-Type";
            HeaderManager headers = (HeaderManager)context.getTestElement();
            Header header = headers.getFirstHeaderNamed(headerName);
            headers.removeHeaderNamed(headerName);
            return header == null ? null : header.getValue();
        }

        private boolean isRawBody(Arguments args) {
            return args.getArgumentCount() == 1 && args.getArgument(0).getName().isEmpty();
        }

        private MethodParam.StringParam buildRawBody(Arguments args) {
            return new MethodParam.StringParam(args.getArgument(0).getValue());
        }

        private void chainContentType(MethodCall ret, String contentType) {
            ret.chain("contentType", new ContentTypeParam(contentType));
        }

        private void chainHeaders(MethodCall ret, MethodCallContext headers) {
            if (headers != null) {
                ret.reChain(headers.buildMethodCall());
            }
        }

        private MethodParam.BoolParam buildFollowRedirectsParam(TestElementParamBuilder paramBuilder) {
            MethodParam.BoolParam follow = paramBuilder.boolParam("HTTPSampler.follow_redirects", true);
            if (!follow.isDefault()) {
                return follow;
            }
            MethodParam.BoolParam auto = paramBuilder.boolParam("HTTPSampler.auto_redirects", false);
            return Boolean.TRUE.equals(auto.getValue()) ? new MethodParam.BoolParam((Boolean)auto.getValue(), true) : follow;
        }

        private static class HttpMethodParam
        extends MethodParam.StringParam {
            private static final Map<String, String> CONSTANT_METHODS = HttpMethodParam.findConstantNames(HTTPConstantsInterface.class, String.class, f -> {
                try {
                    String value = (String)f.get(null);
                    return !"HTTP/1.1".equals(value) && value.equals(value.toUpperCase(Locale.US));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });

            private HttpMethodParam(TestElementParamBuilder paramBuilder) {
                super(paramBuilder.prop("HTTPSampler.method").getStringValue(), "GET");
            }

            @Override
            public boolean isDefault() {
                return this.value == null || ((String)this.value).isEmpty() || this.defaultValue != null && ((String)this.defaultValue).equals(((String)this.value).toUpperCase(Locale.US));
            }

            @Override
            public String buildCode(String indent) {
                String constant = CONSTANT_METHODS.get(this.value != null ? ((String)this.value).toUpperCase(Locale.US) : null);
                return constant != null ? HTTPConstants.class.getSimpleName() + "." + constant : super.buildCode(indent);
            }
        }
    }

    public static enum HttpClientImpl {
        JAVA("Java"),
        HTTP_CLIENT("HttpClient4");

        private static final Map<String, HttpClientImpl> IMPLS_BY_PROPERTY_VALUE;
        public final String propertyValue;

        private HttpClientImpl(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public static HttpClientImpl fromPropertyValue(String propertyValue) {
            if (propertyValue.isEmpty()) {
                return null;
            }
            HttpClientImpl ret = IMPLS_BY_PROPERTY_VALUE.get(propertyValue);
            if (ret == null) {
                throw new IllegalArgumentException("Unknown " + HttpClientImpl.class.getSimpleName() + " property value: " + propertyValue);
            }
            return ret;
        }

        static {
            IMPLS_BY_PROPERTY_VALUE = Arrays.stream(HttpClientImpl.values()).collect(Collectors.toMap(v -> v.propertyValue, v -> v));
        }
    }
}

