/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;

public abstract class MethodParam<T> {
    protected final T value;
    protected final T defaultValue;
    private final Class<T> paramType;

    protected MethodParam(Class<T> paramType, T value, T defaultValue) {
        this.paramType = paramType;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    protected Class<?> getType() {
        return this.paramType;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isDefault() {
        return this.defaultValue != null && this.defaultValue.equals(this.value) || this.value == null;
    }

    protected boolean isIgnored() {
        return false;
    }

    protected abstract String buildCode();

    protected static <T> Map<T, String> findConstantNames(Class<?> constantsHolderClass, Class<T> constantClass, Predicate<Field> filter) {
        return Arrays.stream(constantsHolderClass.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && f.getType() == constantClass && filter.test((Field)f)).collect(Collectors.toMap(f -> {
            try {
                return constantClass.cast(f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, Field::getName));
    }

    public static class ChildrenParam<T>
    extends MethodParam<T> {
        public ChildrenParam(Class<T> childrenClass) {
            super(ChildrenParam.checkChildrenType(childrenClass), null, null);
        }

        private static <T> Class<T> checkChildrenType(Class<T> childrenClass) {
            if (!childrenClass.isArray()) {
                throw new IllegalArgumentException("You need always to provide an array class and not the raw class for the children. Eg use TestPlanChild[].class");
            }
            return childrenClass;
        }

        @Override
        public String buildCode() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DurationParam
    extends MethodParam<Duration> {
        public DurationParam(Duration value, Duration defaultValue) {
            super(Duration.class, value, defaultValue);
        }

        public DurationParam(Duration value) {
            this(value, null);
        }

        @Override
        public String buildCode() {
            return ((Duration)this.value).isZero() ? Duration.class.getSimpleName() + ".ZERO" : MethodCall.forStaticMethod(Duration.class, "ofSeconds", new LongParam(((Duration)this.value).getSeconds())).buildCode();
        }
    }

    public static class BoolParam
    extends LiteralParam<Boolean> {
        public BoolParam(Boolean value, Boolean defaultValue) {
            super(Boolean.TYPE, value == null ? Boolean.FALSE : value, defaultValue);
        }
    }

    public static class LongParam
    extends LiteralParam<Long> {
        public LongParam(Long value, Long defaultValue) {
            super(Long.TYPE, value, defaultValue);
        }

        public LongParam(Long value) {
            this(value, null);
        }
    }

    public static class IntParam
    extends LiteralParam<Integer> {
        public IntParam(Integer value, Integer defaultValue) {
            super(Integer.TYPE, value, defaultValue);
        }

        public IntParam(Integer value) {
            this(value, null);
        }
    }

    public static abstract class LiteralParam<T>
    extends MethodParam<T> {
        protected LiteralParam(Class<T> paramType, T value, T defaultValue) {
            super(paramType, value, defaultValue);
        }

        @Override
        public String buildCode() {
            return String.valueOf(this.value);
        }
    }

    public static class StringParam
    extends MethodParam<String> {
        public StringParam(String value, String defaultValue) {
            super(String.class, value, defaultValue);
        }

        public StringParam(String value) {
            this(value, null);
        }

        @Override
        public boolean isDefault() {
            return super.isDefault() || ((String)this.value).isEmpty();
        }

        @Override
        public String buildCode() {
            return "\"" + ((String)this.value).replaceAll("[\\\\\"\n\t\r]", "\\\\$0") + "\"";
        }
    }

    public static class NameParam
    extends StringParam {
        public NameParam(String name, String defaultName) {
            super(name, defaultName);
        }

        @Override
        public boolean isIgnored() {
            return this.isDefault();
        }
    }
}

