/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.nio.charset.Charset;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.config.gui.HttpDefaultsGui;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;
import us.abstracta.jmeter.javadsl.http.DslHttpSampler;
import us.abstracta.jmeter.javadsl.http.JmeterUrl;

public class DslHttpDefaults
extends BaseConfigElement {
    private String url;
    private Charset encoding;
    private boolean downloadEmbeddedResources;
    private DslHttpSampler.HttpClientImpl clientImpl;

    public DslHttpDefaults() {
        super("HTTP Request Defaults", HttpDefaultsGui.class);
    }

    public DslHttpDefaults url(String url) {
        this.url = url;
        return this;
    }

    public DslHttpDefaults encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpDefaults downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpDefaults clientImpl(DslHttpSampler.HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        ConfigTestElement ret = new ConfigTestElement();
        if (this.url != null) {
            JmeterUrl parsedUrl = JmeterUrl.valueOf(this.url);
            ret.setProperty("HTTPSampler.protocol", parsedUrl.protocol());
            ret.setProperty("HTTPSampler.domain", parsedUrl.host());
            ret.setProperty("HTTPSampler.port", parsedUrl.port());
            ret.setProperty("HTTPSampler.path", parsedUrl.path());
        }
        if (this.encoding != null) {
            ret.setProperty("HTTPSampler.contentEncoding", this.encoding.toString());
        }
        if (this.downloadEmbeddedResources) {
            ret.setProperty("HTTPSampler.image_parser", true);
            ret.setProperty("HTTPSampler.concurrentDwn", true);
        }
        if (this.clientImpl != null) {
            ret.setProperty("HTTPSampler.implementation", this.clientImpl.propertyValue);
        }
        return ret;
    }
}

