/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.assertions.DslAssertion;
import us.abstracta.jmeter.javadsl.core.configs.DslConfig;
import us.abstracta.jmeter.javadsl.core.controllers.DslController;
import us.abstracta.jmeter.javadsl.core.listeners.DslListener;
import us.abstracta.jmeter.javadsl.core.postprocessors.DslPostProcessor;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslPreProcessor;
import us.abstracta.jmeter.javadsl.core.testelements.DslSampler;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;
import us.abstracta.jmeter.javadsl.core.threadgroups.DslThreadGroup;
import us.abstracta.jmeter.javadsl.core.timers.DslTimer;

public class MethodCall {
    private static final String INDENT = "  ";
    private static final Class<?>[][] EXECUTION_ORDERS = new Class[][]{{DslConfig.class}, {DslPreProcessor.class}, {DslTimer.class}, {DslThreadGroup.class, DslController.class, DslSampler.class}, {DslPostProcessor.class}, {DslAssertion.class}, {DslListener.class}};
    private static final MethodCall EMPTY_CALL = new MethodCall(null, Object.class, new MethodParam[0]);
    private final String methodName;
    private final Class<?> returnType;
    private final int executionOrder;
    private final Class<?> childrenType;
    private final List<MethodParam<?>> params;
    private final List<MethodCall> children = new ArrayList<MethodCall>();
    private final List<MethodCall> chain = new ArrayList<MethodCall>();
    private MethodCall childrenMethod;

    private MethodCall(String methodName, Class<?> returnType, MethodParam<?> ... params) {
        this.methodName = methodName;
        this.returnType = returnType;
        this.executionOrder = MethodCall.findExecutionOrder(returnType);
        this.params = Arrays.asList(params);
        if (params.length > 0 && params[params.length - 1] instanceof MethodParam.ChildrenParam) {
            int lastParamIndex = params.length - 1;
            this.childrenType = params[lastParamIndex].getType();
            this.childrenMethod = this;
        } else {
            this.childrenType = null;
        }
    }

    private static int findExecutionOrder(Class<?> returnType) {
        for (int i = 0; i < EXECUTION_ORDERS.length; ++i) {
            if (!Arrays.stream(EXECUTION_ORDERS[i]).anyMatch(c -> c.isAssignableFrom(returnType))) continue;
            return i;
        }
        return -1;
    }

    protected static MethodCall from(Method method, MethodParam<?> ... params) {
        return new MethodCall(method.getName(), method.getReturnType(), params);
    }

    public static MethodCall forStaticMethod(Class<?> methodClass, String methodName, MethodParam<?> ... params) {
        Class[] paramsTypes = (Class[])Arrays.stream(params).map(MethodParam::getType).toArray(Class[]::new);
        Method method = MethodCall.findRequiredStaticMethod(methodClass, methodName, paramsTypes);
        return new MethodCall(methodClass.getSimpleName() + "." + method.getName(), method.getReturnType(), params);
    }

    private static Method findRequiredStaticMethod(Class<?> methodClass, String methodName, Class<?> ... paramsTypes) {
        try {
            Method ret = methodClass.getDeclaredMethod(methodName, paramsTypes);
            if (!Modifier.isPublic(ret.getModifiers()) || !Modifier.isStatic(ret.getModifiers())) {
                throw new RuntimeException("Can't access method " + ret + " which is no longer static or public. Check that no dependencies or APIs have been changed.");
            }
            return ret;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't find method " + methodClass.getName() + "." + methodName + " for parameter types " + Arrays.toString(paramsTypes) + ". Check that no dependencies or APIs have been changed.", e);
        }
    }

    public static MethodCall emptyCall() {
        return EMPTY_CALL;
    }

    protected boolean isEmptyCall() {
        return this == EMPTY_CALL;
    }

    protected static MethodCall buildUnsupported() {
        return new MethodCall("unsupported", UnsupportedTestElement.class, new MethodParam[0]);
    }

    public MethodCall child(MethodCall child) {
        Class<?> childrenType;
        if (this.childrenMethod == null) {
            this.childrenMethod = this.findChildrenMethod();
        }
        if (!(childrenType = this.childrenMethod.childrenType.getComponentType()).isAssignableFrom(child.returnType)) {
            throw new IllegalArgumentException("Trying to add a child of type " + child.returnType + " that is not compatible with the declared ones for the method " + this.methodName + ": " + childrenType);
        }
        this.childrenMethod.children.add(child);
        if (this.childrenMethod != this && (this.chain.isEmpty() || this.chain.get(this.chain.size() - 1) != this.childrenMethod)) {
            this.chain.add(this.childrenMethod);
        }
        return this.childrenMethod;
    }

    private MethodCall findChildrenMethod() {
        if (this.childrenType != null) {
            return this;
        }
        Method childrenMethod = null;
        for (Class<?> methodHolder = this.returnType; childrenMethod == null && methodHolder != Object.class; methodHolder = methodHolder.getSuperclass()) {
            childrenMethod = Arrays.stream(methodHolder.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && "children".equals(m.getName()) && m.getParameterCount() == 1).findAny().orElse(null);
        }
        if (childrenMethod == null) {
            throw new IllegalStateException("No children method found for " + this.returnType + ". This might be due to unexpected test plan structure or missing method in test element. Please create an issue in GitHub repository if you find any of these cases.");
        }
        return new MethodCall(childrenMethod.getName(), childrenMethod.getReturnType(), new MethodParam.ChildrenParam(childrenMethod.getParameterTypes()[0]));
    }

    public MethodCall chain(String methodName, MethodParam<?> ... params) {
        if (params.length == 1 && params[0].isDefault()) {
            return this;
        }
        Method method = this.findMethodInClassHierarchyMatchingParams(methodName, this.returnType, params);
        if (method == null && params.length == 1 && params[0] instanceof MethodParam.BoolParam && (method = this.findMethodInClassHierarchyMatchingParams(methodName, this.returnType, new MethodParam[0])) != null) {
            params = new MethodParam[]{};
        }
        if (method == null) {
            throw MethodCall.buildNoMatchingMethodFoundException("public '" + methodName + "' method in " + this.returnType.getName(), params);
        }
        this.chain.add(MethodCall.from(method, params));
        return this;
    }

    private Method findMethodInClassHierarchyMatchingParams(String methodName, Class<?> methodClass, MethodParam<?>[] params) {
        Method ret = null;
        while (ret == null && methodClass != Object.class) {
            ret = this.findMethodInClassMatchingParams(methodName, methodClass, params);
            methodClass = methodClass.getSuperclass();
        }
        return ret;
    }

    private Method findMethodInClassMatchingParams(String methodName, Class<?> methodClass, MethodParam<?>[] params) {
        Stream<Method> chainableMethods = Arrays.stream(methodClass.getDeclaredMethods()).filter(m -> methodName.equals(m.getName()) && Modifier.isPublic(m.getModifiers()) && m.getReturnType() == methodClass);
        return MethodCall.findParamsMatchingMethod(chainableMethods, params);
    }

    protected static Method findParamsMatchingMethod(Stream<Method> methods, MethodParam<?>[] params) {
        List finalParams = Arrays.stream(params).filter(p -> !p.isIgnored()).collect(Collectors.toList());
        return methods.filter(m -> MethodCall.methodMatchesParameters(m, finalParams)).findAny().orElse(null);
    }

    private static boolean methodMatchesParameters(Method m, List<MethodParam<?>> params) {
        if (m.getParameterCount() != params.size()) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i).getType().isAssignableFrom(paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    protected static UnsupportedOperationException buildNoMatchingMethodFoundException(String methodCondition, MethodParam<?>[] params) {
        return new UnsupportedOperationException("No " + methodCondition + " method was found for parameters " + Arrays.toString(params) + ". This is probably due to some change in DSL not reflected in associated code builder.");
    }

    public void reChain(MethodCall other) {
        this.chain.addAll(other.chain);
    }

    public String buildCode() {
        return this.buildCode("");
    }

    private String buildCode(String indent) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.methodName).append("(");
        ret.append(this.params.stream().filter(p -> !p.isIgnored() && !(p instanceof MethodParam.ChildrenParam)).map(MethodParam::buildCode).collect(Collectors.joining(", ")));
        String childIndent = indent + INDENT;
        List children = this.children.stream().sorted(Comparator.comparing(c -> c.executionOrder)).collect(Collectors.toList());
        if (!children.isEmpty()) {
            if (ret.charAt(ret.length() - 1) != '(') {
                ret.append(",");
            }
            ret.append("\n").append(childIndent);
            ret.append(children.stream().map(c -> c.buildCode(childIndent)).collect(Collectors.joining(",\n" + childIndent)));
            ret.append("\n").append(indent);
        }
        ret.append(")");
        if (!this.chain.isEmpty()) {
            if (children.isEmpty()) {
                ret.append("\n").append(childIndent);
            }
            ret.append(".");
            ret.append(this.chain.stream().map(c -> c.buildCode(childIndent)).collect(Collectors.joining("\n" + childIndent + ".")));
        }
        return ret.toString();
    }

    private static class UnsupportedTestElement
    implements MultiLevelTestElement {
        private UnsupportedTestElement() {
        }

        public void children(DslTestElement ... child) {
        }

        @Override
        public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
            return null;
        }

        @Override
        public void showInGui() {
        }
    }
}

