/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups;

import java.util.List;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.threads.AbstractThreadGroup;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;

public abstract class DslSimpleThreadGroup<T extends DslSimpleThreadGroup<?>>
extends BaseThreadGroup<T> {
    private int threadCount = 1;
    private int iterations = 1;

    protected DslSimpleThreadGroup(String name, Class<? extends JMeterGUIComponent> guiClass, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(name, guiClass, children);
    }

    public T iterations(int iterations) {
        this.iterations = iterations;
        return (T)this;
    }

    public T threadCount(int threadCount) {
        this.threadCount = threadCount;
        return (T)this;
    }

    @Override
    public T children(BaseThreadGroup.ThreadGroupChild ... children) {
        return (T)((DslSimpleThreadGroup)super.children(children));
    }

    @Override
    protected AbstractThreadGroup buildThreadGroup() {
        AbstractThreadGroup ret = this.buildSimpleThreadGroup();
        LoopController loopController = new LoopController();
        ret.setNumThreads(this.threadCount);
        ret.setSamplerController(loopController);
        loopController.setLoops(this.iterations);
        return ret;
    }

    protected abstract AbstractThreadGroup buildSimpleThreadGroup();
}

