/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.configs;

import org.apache.jmeter.config.CSVDataSet;
import org.apache.jmeter.config.CSVDataSetBeanInfo;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public class DslCsvDataSet
extends BaseTestElement
implements MultiLevelTestElement {
    private final String file;
    private String delimiter = ",";
    private String encoding;
    private String[] variableNames;
    private boolean ignoreFirstLine;
    private boolean stopThread;
    private Sharing shareMode = Sharing.ALL_THREADS;

    public DslCsvDataSet(String csvFile) {
        super("CSV Data Set Config", TestBeanGUI.class);
        this.file = csvFile;
    }

    public DslCsvDataSet delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public DslCsvDataSet encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslCsvDataSet variableNames(String ... variableNames) {
        this.variableNames = variableNames;
        return this;
    }

    public DslCsvDataSet ignoreFirstLine() {
        this.ignoreFirstLine = true;
        return this;
    }

    public DslCsvDataSet stopThreadOnEOF() {
        this.stopThread = true;
        return this;
    }

    public DslCsvDataSet sharedIn(Sharing shareMode) {
        this.shareMode = shareMode;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        CSVDataSet ret = new CSVDataSet();
        ret.setFilename(this.file);
        ret.setDelimiter(this.delimiter);
        ret.setFileEncoding(this.encoding);
        if (this.variableNames != null) {
            ret.setVariableNames(String.join((CharSequence)",", this.variableNames));
        }
        ret.setIgnoreFirstLine(this.ignoreFirstLine);
        ret.setQuotedData(true);
        ret.setRecycle(!this.stopThread);
        ret.setStopThread(this.stopThread);
        ret.setShareMode(this.shareMode.jmeterPropertyValue);
        return ret;
    }

    @Override
    protected BeanInfoSupport getBeanInfo() {
        return new CSVDataSetBeanInfo();
    }

    public static enum Sharing {
        ALL_THREADS("all"),
        THREAD_GROUP("group"),
        THREAD("thread");

        private final String jmeterPropertyValue;

        private Sharing(String jmeterPropertySuffix) {
            this.jmeterPropertyValue = "shareMode." + jmeterPropertySuffix;
        }
    }
}

