/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.wrapper.wrappers;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class TestElementWrapperHelper<T extends TestElement> {
    private final T testElement;
    private final JMeterGUIComponent guiComponent;
    private final Map<String, Object> props = new HashMap<String, Object>();

    public TestElementWrapperHelper(T testElement, JMeterGUIComponent guiComponent) {
        this.testElement = testElement;
        this.guiComponent = guiComponent;
    }

    public static String solveName(String name, TestElement testElement, JMeterGUIComponent guiComponent) {
        if (name != null) {
            return name;
        }
        if (testElement != null) {
            return testElement.getName();
        }
        return guiComponent.getName();
    }

    public static Class<? extends JMeterGUIComponent> solveGuiClass(TestElement testElement, JMeterGUIComponent guiComponent) {
        if (testElement instanceof TestBean) {
            return TestBeanGUI.class;
        }
        if (guiComponent != null) {
            return guiComponent.getClass();
        }
        return null;
    }

    public void prop(String name, Object value) {
        this.props.put(name, value);
    }

    public T buildTestElement() {
        Object ret = this.testElement != null ? this.testElement : this.guiComponent.createTestElement();
        this.props.forEach((k, v) -> {
            JMeterProperty prop = AbstractProperty.createProperty((Object)v);
            prop.setName(k);
            ret.setProperty(prop);
        });
        return ret;
    }
}

