/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.dashboard;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import kg.apc.charting.GraphPanelChart;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.vizualizers.ResponseCodesPerSecondGui;
import kg.apc.jmeter.vizualizers.ResponseTimesOverTimeGui;
import kg.apc.jmeter.vizualizers.ThreadsStateOverTimeGui;
import kg.apc.jmeter.vizualizers.TransactionsPerSecondGui;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.SummaryReport;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.NumberRenderer;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.listeners.DslVisualizer;

public class DashboardVisualizer
extends DslVisualizer {
    public DashboardVisualizer() {
        super(null, null);
    }

    public static DashboardVisualizer dashboardVisualizer() {
        return new DashboardVisualizer();
    }

    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        if (GraphicsEnvironment.isHeadless()) {
            this.logNonGuiExecutionWarning();
            return parent;
        }
        List<AbstractOverTimeVisualizer> graphs = Arrays.asList(new ThreadsStateOverTimeGui(), new ResponseTimesOverTimeGui(), new TransactionsPerSecondGui(), new ResponseCodesPerSecondGui());
        graphs.forEach(g -> parent.add((Object)this.buildGraphTestElement((AbstractOverTimeVisualizer)g, context)));
        SummaryReport summary = new SummaryReport();
        parent.add((Object)this.buildVisualizerTestElement((AbstractVisualizer)summary, v -> v.getComponent(1), 0, context));
        context.addVisualizer((DslVisualizer)this, () -> this.buildGui(graphs, summary));
        return parent;
    }

    private TestElement buildGraphTestElement(AbstractOverTimeVisualizer graph, BuildTreeContext buildContext) {
        GraphPanelChart graphPanelChart = graph.getGraphPanelChart();
        graphPanelChart.setxAxisLabelRenderer((NumberRenderer)new RelativeMinutesTimeRenderer());
        graphPanelChart.getChartSettings().setUseRelativeTime(false);
        return this.buildVisualizerTestElement((AbstractVisualizer)graph, v -> ((AbstractGraphPanelVisualizer)v).getGraphPanelChart(), 500, buildContext);
    }

    public TestElement buildVisualizerTestElement(AbstractVisualizer visualizer, Function<AbstractVisualizer, Component> subComponentLocator, int repaintIntervalMillis, BuildTreeContext context) {
        AbstractListenerElement testElement = (AbstractListenerElement)visualizer.createTestElement();
        visualizer.configure((TestElement)testElement);
        Component subComponent = subComponentLocator.apply(visualizer);
        Visualizer rePainter = this.buildSubComponentRePainter(visualizer, subComponent, repaintIntervalMillis);
        testElement.setListener(rePainter);
        ((ArrayList)context.getRoot().getOrCreateEntry(((Object)((Object)this)).getClass().getSimpleName(), ArrayList::new)).add(rePainter);
        return testElement;
    }

    private Visualizer buildSubComponentRePainter(final AbstractVisualizer delegate, final Component subComponent, final long repaintIntervalMillis) {
        return new Visualizer(){
            private long lastRepaint;

            public void add(SampleResult sample) {
                delegate.add(sample);
                if (repaintIntervalMillis <= 0L) {
                    subComponent.repaint();
                } else {
                    long now = System.currentTimeMillis();
                    if (now - this.lastRepaint >= repaintIntervalMillis) {
                        subComponent.repaint();
                        this.lastRepaint = now;
                    }
                }
            }

            public boolean isStats() {
                return false;
            }
        };
    }

    protected TestElement buildTestElement() {
        return null;
    }

    protected Component buildGui(List<AbstractOverTimeVisualizer> graphs, SummaryReport summary) {
        JSplitPane ret = new JSplitPane(0, this.buildGraphsPanel(graphs), this.buildSummaryPanel(summary));
        ret.setResizeWeight(1.0);
        return ret;
    }

    private JPanel buildGraphsPanel(List<AbstractOverTimeVisualizer> graphs) {
        JPanel graphsPanel = new JPanel();
        graphsPanel.setLayout(new GridLayout(0, 2));
        graphs.forEach(g -> graphsPanel.add((Component)g.getGraphPanelChart()));
        return graphsPanel;
    }

    private Component buildSummaryPanel(SummaryReport summary) {
        return summary.getComponent(1);
    }

    public void showTestElementGui(Component guiComponent, Runnable closeListener) {
        this.showFrameWith(guiComponent, "Dashboard", 1080, 600, closeListener);
    }

    public void showInGui() {
        throw new UnsupportedOperationException("Dashboard has no built-in JMeter GUI");
    }

    private static final class RelativeMinutesTimeRenderer
    extends NumberRenderer {
        private long firstVal;

        private RelativeMinutesTimeRenderer() {
        }

        public void setValue(Object value) {
            this.setText(this.buildTimeString(value));
        }

        private String buildTimeString(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Double) {
                value = Math.round((Double)value);
            }
            this.firstVal = this.firstVal == 0L ? (Long)value : Math.min(this.firstVal, (Long)value);
            Duration time = Duration.ofMillis((Long)value - this.firstVal);
            return String.format("%02d:%02d", time.toMinutes(), time.getSeconds() % 60L);
        }
    }
}

