/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterClient;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterTestPlanStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.Project;
import us.abstracta.jmeter.javadsl.blazemeter.api.Test;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRun;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunStatus;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;

public class BlazeMeterEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BlazeMeterEngine.class);
    private static final String BASE_URL = "https://a.blazemeter.com";
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private final BlazeMeterClient client;
    private String testName = "jmeter-java-dsl";
    private Long projectId;
    private Duration testTimeout = Duration.ofHours(1L);
    private Duration availableDataTimeout = Duration.ofSeconds(30L);
    private Integer totalUsers;
    private Duration rampUp;
    private Integer iterations;
    private Duration holdFor;
    private Integer threadsPerEngine;
    private boolean useDebugRun;

    public BlazeMeterEngine(String authToken) {
        this.client = new BlazeMeterClient("https://a.blazemeter.com/api/v4/", authToken);
    }

    public BlazeMeterEngine testName(String testName) {
        this.testName = testName;
        return this;
    }

    public BlazeMeterEngine projectId(long projectId) {
        this.projectId = projectId;
        return this;
    }

    public BlazeMeterEngine testTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    public BlazeMeterEngine availableDataTimeout(Duration availableDataTimeout) {
        this.availableDataTimeout = availableDataTimeout;
        return this;
    }

    public BlazeMeterEngine totalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
        return this;
    }

    public BlazeMeterEngine rampUpFor(Duration rampUp) {
        this.rampUp = rampUp;
        return this;
    }

    public BlazeMeterEngine iterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public BlazeMeterEngine holdFor(Duration holdFor) {
        this.holdFor = holdFor;
        return this;
    }

    public BlazeMeterEngine threadsPerEngine(int threadsPerEngine) {
        this.threadsPerEngine = threadsPerEngine;
        return this;
    }

    public BlazeMeterEngine useDebugRun() {
        this.useDebugRun = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlazeMeterTestPlanStats run(DslTestPlan testPlan) throws IOException, InterruptedException, TimeoutException {
        Project project = this.findProject();
        File jmxFile = Files.createTempDirectory("jmeter-dsl", new FileAttribute[0]).resolve("test.jmx").toFile();
        try {
            this.saveTestPlanTo(testPlan, jmxFile);
            Test test = this.client.findTestByName(this.testName, project).orElse(null);
            TestConfig testConfig = this.buildTestConfig(project, jmxFile);
            if (test != null) {
                this.client.updateTest(test, testConfig);
                LOG.info("Updated test {}", (Object)test.getUrl());
            } else {
                test = this.client.createTest(testConfig, project);
                LOG.info("Created test {}", (Object)test.getUrl());
            }
            this.client.uploadTestFile(test, jmxFile);
            TestRun testRun = this.client.startTest(test, this.buildTestRunConfig());
            LOG.info("Started test run {}", (Object)testRun.getUrl());
            this.awaitTestEnd(testRun);
            BlazeMeterTestPlanStats blazeMeterTestPlanStats = this.findTestPlanStats(testRun);
            return blazeMeterTestPlanStats;
        }
        finally {
            if (jmxFile.delete()) {
                jmxFile.getParentFile().delete();
            }
        }
    }

    private Project findProject() throws IOException {
        String appBaseUrl = "https://a.blazemeter.com/app/#";
        return this.projectId == null ? this.client.findDefaultProject(appBaseUrl) : this.client.findProjectById(this.projectId, appBaseUrl);
    }

    private void saveTestPlanTo(DslTestPlan testPlan, File jmxFile) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        try (FileOutputStream output = new FileOutputStream(jmxFile.getPath());){
            ListedHashTree tree = new ListedHashTree();
            BuildTreeContext context = new BuildTreeContext();
            context.buildTreeFor((DslTestElement)testPlan, (HashTree)tree);
            env.saveTree((HashTree)tree, output);
            context.getVisualizers().forEach((v, e) -> LOG.warn("BlazeMeterEngine does not currently support displaying visualizers. Ignoring {}.", (Object)v.getClass().getSimpleName()));
        }
    }

    private TestConfig buildTestConfig(Project project, File jmxFile) {
        return new TestConfig().name(this.testName).projectId(project.getId()).jmxFile(jmxFile).totalUsers(this.totalUsers).rampUp(this.rampUp).iterations(this.iterations).holdFor(this.holdFor).threadsPerEngine(this.threadsPerEngine);
    }

    private TestRunConfig buildTestRunConfig() {
        TestRunConfig ret = new TestRunConfig();
        if (this.useDebugRun) {
            ret.debugRun();
        }
        return ret;
    }

    private void awaitTestEnd(TestRun testRun) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status = TestRunStatus.CREATED;
        Instant testStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            TestRunStatus newStatus = this.client.findTestRunStatus(testRun);
            if (status.equals(newStatus)) continue;
            LOG.debug("Test run {} status changed to: {}", (Object)testRun.getUrl(), (Object)newStatus);
            status = newStatus;
        } while (!TestRunStatus.ENDED.equals(status) && !this.hasTimedOut(testStart, this.testTimeout));
        if (!TestRunStatus.ENDED.equals(status)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            this.awaitAvailableData(testRun, testStart);
        }
    }

    private boolean hasTimedOut(Instant start, Duration timeout) {
        return Duration.between(start, Instant.now()).compareTo(timeout) >= 0;
    }

    private TimeoutException buildTestTimeoutException(TestRun testRun) {
        return new TimeoutException(String.format("Test %s didn't end after %s. If the timeout is too short, you can change it with testTimeout() method.", testRun.getUrl(), this.testTimeout));
    }

    private void awaitAvailableData(TestRun testRun, Instant testStart) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status;
        Instant dataPollStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
        } while (!(status = this.client.findTestRunStatus(testRun)).isDataAvailable() && !this.hasTimedOut(testStart, this.testTimeout) && !this.hasTimedOut(dataPollStart, this.availableDataTimeout));
        if (this.hasTimedOut(testStart, this.testTimeout)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            throw new TimeoutException(String.format("Test %s ended, but no data is available after %s. This is usually caused by some failure in BlazeMeter. Check bzt.log and jmeter.out, and if everything looks good you might try increasing this timeout with availableDataTimeout() method.", testRun.getUrl(), this.availableDataTimeout));
        }
    }

    private BlazeMeterTestPlanStats findTestPlanStats(TestRun testRun) throws IOException {
        TestRunSummaryStats.TestRunLabeledSummary summary = this.client.findTestRunSummaryStats(testRun).getSummary().get(0);
        List<TestRunRequestStats> labeledStats = this.client.findTestRunRequestStats(testRun);
        return new BlazeMeterTestPlanStats(summary, labeledStats);
    }
}

