/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ProcessEnvironmentInterceptor {
    private static Map<String, String> CURRENT_ENVIRONMENT_VARIABLES = new HashMap<String, String>();

    @SuppressFBWarnings(value={"EI_EXPOSE_STATIC_REP2"})
    public static void setEnv(Map<String, String> env) {
        CURRENT_ENVIRONMENT_VARIABLES = env;
    }

    public static Map<String, String> getenv() {
        return ProcessEnvironmentInterceptor.filterNulls(CURRENT_ENVIRONMENT_VARIABLES);
    }

    public static String getenv(String name) {
        return ProcessEnvironmentInterceptor.getenv().get(name);
    }

    public static Map<String, String> environment() {
        return ProcessEnvironmentInterceptor.getenv();
    }

    public static String toEnvironmentBlock(Map<String, String> m) {
        ArrayList<Map.Entry<String, String>> list = m != null ? new ArrayList<Map.Entry<String, String>>(m.entrySet()) : new ArrayList<Map.Entry<String, String>>(ProcessEnvironmentInterceptor.getenv().entrySet());
        Collections.sort(list, (e1, e2) -> NameComparator.compareNames((String)e1.getKey(), (String)e2.getKey()));
        StringBuilder sb = new StringBuilder(list.size() * 30);
        int cmp = -1;
        String systemRoot = "SystemRoot";
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (cmp < 0 && (cmp = NameComparator.compareNames(key, "SystemRoot")) > 0) {
                ProcessEnvironmentInterceptor.addToEnvIfSet(sb, "SystemRoot");
            }
            ProcessEnvironmentInterceptor.addToEnv(sb, key, value);
        }
        if (cmp < 0) {
            ProcessEnvironmentInterceptor.addToEnvIfSet(sb, "SystemRoot");
        }
        if (sb.length() == 0) {
            sb.append('\u0000');
        }
        sb.append('\u0000');
        return sb.toString();
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS", "DM_DEFAULT_ENCODING"})
    public static byte[] toEnvironmentBlock(Map<String, String> m, int[] envc) {
        if (m == null) {
            return null;
        }
        int count = m.size() * 2;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            count += entry.getKey().getBytes().length;
            count += entry.getValue().getBytes().length;
        }
        byte[] block = new byte[count];
        int i = 0;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            byte[] key = entry.getKey().getBytes();
            byte[] value = entry.getValue().getBytes();
            System.arraycopy(key, 0, block, i, key.length);
            i += key.length;
            block[i++] = 61;
            System.arraycopy(value, 0, block, i, value.length);
            i += value.length + 1;
        }
        envc[0] = m.size();
        return block;
    }

    private static Map<String, String> filterNulls(Map<String, String> currentMockedEnvironment) {
        return currentMockedEnvironment.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static void addToEnvIfSet(StringBuilder sb, String name) {
        String s = ProcessEnvironmentInterceptor.getenv().get(name);
        if (s != null) {
            ProcessEnvironmentInterceptor.addToEnv(sb, name, s);
        }
    }

    private static void addToEnv(StringBuilder sb, String name, String val) {
        sb.append(name).append('=').append(val).append('\u0000');
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return NameComparator.compareNames(s1, s2);
        }

        public static int compareNames(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

