/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition.tree;

import java.util.List;
import java.util.regex.Pattern;
import uk.org.webcompere.modelassert.json.PathWildCard;
import uk.org.webcompere.modelassert.json.condition.tree.Location;
import uk.org.webcompere.modelassert.json.condition.tree.RegexPathMatcher;
import uk.org.webcompere.modelassert.json.condition.tree.StringPathMatcher;
import uk.org.webcompere.modelassert.json.condition.tree.WildCardPathMatcher;

public interface PathMatcher {
    public boolean matches(Location var1, List<PathMatcher> var2);

    public static PathMatcher of(Object value) {
        if (value instanceof String) {
            return new StringPathMatcher((String)value);
        }
        if (value instanceof PathWildCard) {
            return new WildCardPathMatcher((PathWildCard)((Object)value));
        }
        if (value instanceof Pattern) {
            return new RegexPathMatcher((Pattern)value);
        }
        throw new IllegalArgumentException("Unexpected path part: " + value + ". Expecting String, Pattern or PathWildCard");
    }

    public static boolean matchesTheRest(Location location, List<PathMatcher> remaining) {
        if (remaining.isEmpty() && location.isEmpty()) {
            return true;
        }
        if (!location.isEmpty() && remaining.isEmpty()) {
            return false;
        }
        return remaining.get(0).matches(location, remaining.subList(1, remaining.size()));
    }
}

