/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific.tree;

import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.condition.Ignore;
import uk.org.webcompere.modelassert.json.condition.tree.PathMatch;
import uk.org.webcompere.modelassert.json.condition.tree.PathRule;
import uk.org.webcompere.modelassert.json.condition.tree.TreeRule;
import uk.org.webcompere.modelassert.json.dsl.JsonNodeAssertDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.tree.WhereDsl;

public class PathDsl<A>
implements JsonNodeAssertDsl<WhereDsl<A>> {
    private WhereDsl<A> whereDsl;
    private PathMatch pathMatch;

    PathDsl(WhereDsl<A> whereDsl, Object pathStart, Object ... pathRemainder) {
        this(whereDsl, new PathMatch(pathStart, pathRemainder));
    }

    private PathDsl(WhereDsl<A> whereDsl, PathMatch pathMatch) {
        this.whereDsl = whereDsl;
        this.pathMatch = pathMatch;
    }

    public static <A> PathDsl<A> fromJsonPointer(WhereDsl<A> where, String jsonPointer) {
        return new PathDsl<A>(where, PathMatch.ofJsonPointer(jsonPointer));
    }

    @Override
    public WhereDsl<A> satisfies(Condition condition) {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, condition));
    }

    public WhereDsl<A> keysInAnyOrder() {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, TreeRule.IGNORE_KEY_ORDER));
    }

    public WhereDsl<A> keysInOrder() {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, TreeRule.REQUIRE_KEY_ORDER));
    }

    public WhereDsl<A> objectContains() {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, TreeRule.OBJECT_CONTAINS));
    }

    public WhereDsl<A> arrayInAnyOrder() {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, TreeRule.IGNORE_ARRAY_ORDER));
    }

    public WhereDsl<A> arrayContains() {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, TreeRule.ARRAY_CONTAINS));
    }

    public WhereDsl<A> isIgnored() {
        return this.whereDsl.pathRule(new PathRule(this.pathMatch, new Ignore()));
    }
}

