/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import uk.org.webcompere.modelassert.json.condition.HasValueWithLooseType;
import uk.org.webcompere.modelassert.json.condition.IsEmpty;
import uk.org.webcompere.modelassert.json.condition.MatcherCondition;
import uk.org.webcompere.modelassert.json.condition.MissingCondition;
import uk.org.webcompere.modelassert.json.condition.Not;
import uk.org.webcompere.modelassert.json.condition.NullCondition;
import uk.org.webcompere.modelassert.json.condition.PredicateWrappedCondition;
import uk.org.webcompere.modelassert.json.dsl.JsonAssertDslBuilders;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.ArrayNodeDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.ArrayNodes;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.BooleanNodeDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.BooleanNodes;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.NumberNodeDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.NumberNodes;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.ObjectNodeDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.ObjectNodes;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.TextNodeDsl;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.TextNodes;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.TreeComparisonDsl;

public interface JsonNodeAssertDsl<A>
extends Satisfies<A>,
TextNodeDsl<A>,
NumberNodeDsl<A>,
BooleanNodeDsl<A>,
ObjectNodeDsl<A>,
ArrayNodeDsl<A>,
TreeComparisonDsl<A> {
    default public A hasValue(Object expected) {
        return this.satisfies(new HasValueWithLooseType(expected));
    }

    default public A isNull() {
        return this.satisfies(NullCondition.getInstance());
    }

    default public A isNotNull() {
        return this.satisfies(Not.not(NullCondition.getInstance()));
    }

    default public A isMissing() {
        return this.satisfies(MissingCondition.getInstance());
    }

    default public A isNotMissing() {
        return this.satisfies(Not.not(MissingCondition.getInstance()));
    }

    default public A isAnyNode() {
        return this.isNotMissing();
    }

    default public A is(String description, Predicate<JsonNode> customCondition) {
        return this.satisfies(new PredicateWrappedCondition(description, customCondition));
    }

    default public A is(Function<JsonNodeAssertDsl<A>, A> customisedBy) {
        return customisedBy.apply(this);
    }

    default public A isNot(String description, Predicate<JsonNode> customCondition) {
        return this.satisfies(Not.not(new PredicateWrappedCondition(description, customCondition)));
    }

    default public A matches(Matcher<JsonNode> matcher) {
        return this.satisfies(new MatcherCondition(matcher));
    }

    default public NumberNodes<A> number() {
        return new NumberNodes(this);
    }

    default public TextNodes<A> text() {
        return new TextNodes(this);
    }

    default public BooleanNodes<A> booleanNode() {
        return new BooleanNodes(this);
    }

    default public ArrayNodes<A> array() {
        return new ArrayNodes(this);
    }

    default public ObjectNodes<A> object() {
        return new ObjectNodes(this);
    }

    default public JsonAssertDslBuilders.At<A> at(String path) {
        return new JsonAssertDslBuilders.At(this, path);
    }

    default public A isNotEmpty() {
        return this.satisfies(Not.not(new IsEmpty()));
    }
}

