/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.migrate;

import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;

public class NumRecordMigration
implements Function<String, String> {
    public static final String OLD_NUM_RECORD_PREFIX = "_n=";
    public static final String NEW_NUM_RECORD_PREFIX = "@n=";

    private String migrateUnderscoreN_to_atN(String s) {
        if (s.startsWith(OLD_NUM_RECORD_PREFIX)) {
            return s.replaceFirst(OLD_NUM_RECORD_PREFIX, NEW_NUM_RECORD_PREFIX);
        }
        return s;
    }

    @Override
    public String apply(@NonNull String numRecord) {
        if (numRecord == null) {
            throw new NullPointerException("numRecord is marked non-null but is null");
        }
        return Optional.of(numRecord).map(this::migrateUnderscoreN_to_atN).orElse(numRecord);
    }
}

