/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class UnicodeEscapeReplacer {
    private static final int HEX = 16;
    private static final int UNICODE_SEQ_LEN = 6;
    private static final Pattern reg = Pattern.compile("[~\\\\]u[0-9a-fA-F]{4}");

    static String convertUnicodeSequences(String str) {
        int start = 0;
        StringBuilder result = new StringBuilder();
        Matcher m = reg.matcher(str);
        while (m.find()) {
            if (m.start() > 0 && (str.charAt(m.start() - 1) == '\\' || str.charAt(m.start() - 1) == '~')) {
                if (start < m.start() - 1) {
                    result.append(str, start, m.start() - 1);
                }
                result.append(str, m.start(), m.start() + 6);
            } else {
                if (start < m.start()) {
                    result.append(str, start, m.start());
                }
                int c = Integer.parseInt(str.substring(m.start() + 2, m.start() + 6), 16);
                result.append(Character.toChars(c));
            }
            start = m.start() + 6;
        }
        result.append(str.substring(start));
        return result.toString();
    }

    private UnicodeEscapeReplacer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

