/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter.tokeniser;

import java.util.LinkedList;
import java.util.regex.Pattern;
import lombok.NonNull;
import uk.modl.interpreter.tokeniser.Token;
import uk.modl.interpreter.tokeniser.TokenType;
import uk.modl.interpreter.tokeniser.TokeniserException;

class Context {
    private static final String WS = " \t\r\n";
    private static final String nonStringTokens = "[]();\"=`";
    private static final Pattern INTEGER_REGEX = Pattern.compile("^-?(?:0|[1-9]\\d*)$");
    private static final Pattern FLOAT_REGEX = Pattern.compile("^-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?$");
    private final String s;
    private final LinkedList<Token> tokens = new LinkedList();
    private int tokStart = 0;

    Context(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        this.s = s;
    }

    private static int scanToEndOfQuoted(@NonNull String s, int start, char quoteChar) {
        int end;
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        for (end = start + 1; end < s.length(); ++end) {
            char endChar = s.charAt(end);
            char prevChar = s.charAt(end - 1);
            if (endChar == quoteChar && prevChar != '\\' && prevChar != '~') break;
        }
        if (s.charAt(end) != quoteChar) {
            throw new TokeniserException(String.format("Unclosed quote: %c in %s near %d:%d", Character.valueOf(quoteChar), s, start, end));
        }
        return end + 1;
    }

    private static int scanToEndOfString(@NonNull String s, int start) {
        int end;
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        for (end = start + 1; end < s.length() && (nonStringTokens.indexOf(s.charAt(end)) <= -1 || Context.escaped(s, end - 1)); ++end) {
        }
        return end;
    }

    private static boolean escaped(@NonNull String s, int index) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return index >= 0 && (s.charAt(index) == '~' || s.charAt(index) == '\\');
    }

    LinkedList<Token> parse() {
        boolean more;
        while (more = this.next()) {
        }
        return this.tokens;
    }

    private boolean next() {
        int tokEnd;
        TokenType tokType;
        char ws;
        while (this.tokStart < this.s.length() && WS.indexOf(ws = this.s.charAt(this.tokStart)) >= 0) {
            ++this.tokStart;
        }
        if (this.tokStart >= this.s.length()) {
            return false;
        }
        switch (this.s.charAt(this.tokStart)) {
            case '(': {
                tokType = TokenType.LPAREN;
                tokEnd = this.tokStart + 1;
                break;
            }
            case ')': {
                tokType = TokenType.RPAREN;
                tokEnd = this.tokStart + 1;
                break;
            }
            case '[': {
                tokType = TokenType.LBRACKET;
                tokEnd = this.tokStart + 1;
                break;
            }
            case ']': {
                tokType = TokenType.RBRACKET;
                tokEnd = this.tokStart + 1;
                break;
            }
            case ';': {
                tokType = TokenType.STRUCT_SEP;
                tokEnd = this.tokStart + 1;
                break;
            }
            case '=': {
                tokType = TokenType.EQUALS;
                tokEnd = this.tokStart + 1;
                break;
            }
            case '\"': 
            case '`': {
                tokType = TokenType.QUOTED;
                tokEnd = Context.scanToEndOfQuoted(this.s, this.tokStart, this.s.charAt(this.tokStart));
                break;
            }
            default: {
                tokType = TokenType.STRING;
                tokEnd = Context.scanToEndOfString(this.s, this.tokStart);
            }
        }
        String tokValue = this.s.substring(this.tokStart, tokEnd).trim();
        if (INTEGER_REGEX.matcher(tokValue).matches()) {
            int number = Integer.parseInt(tokValue);
            this.tokens.add(new Token(TokenType.INTEGER, number, this.tokStart, tokEnd));
        } else if (FLOAT_REGEX.matcher(tokValue).matches()) {
            float number = Float.parseFloat(tokValue);
            this.tokens.add(new Token(TokenType.FLOAT, Float.valueOf(number), this.tokStart, tokEnd));
        } else if (tokValue.equals("null")) {
            this.tokens.add(new Token(TokenType.NULL, null, this.tokStart, tokEnd));
        } else if (tokValue.equals("true")) {
            this.tokens.add(new Token(TokenType.TRUE, true, this.tokStart, tokEnd));
        } else if (tokValue.equals("false")) {
            this.tokens.add(new Token(TokenType.FALSE, false, this.tokStart, tokEnd));
        } else {
            this.tokens.add(new Token(tokType, tokValue, this.tokStart, tokEnd));
        }
        this.tokStart = tokEnd;
        return tokEnd < this.s.length();
    }
}

