/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter.parser;

import io.vavr.API;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import uk.modl.interpreter.model.Modl;
import uk.modl.interpreter.model.ModlArray;
import uk.modl.interpreter.model.ModlBoolNull;
import uk.modl.interpreter.model.ModlFloat;
import uk.modl.interpreter.model.ModlInteger;
import uk.modl.interpreter.model.ModlMap;
import uk.modl.interpreter.model.ModlPair;
import uk.modl.interpreter.model.ModlPrimitive;
import uk.modl.interpreter.model.ModlQuoted;
import uk.modl.interpreter.model.ModlString;
import uk.modl.interpreter.model.ModlStructure;
import uk.modl.interpreter.model.ModlValue;
import uk.modl.interpreter.parser.ParserException;
import uk.modl.interpreter.tokeniser.Token;
import uk.modl.interpreter.tokeniser.TokenStream;
import uk.modl.interpreter.tokeniser.TokenType;
import uk.modl.interpreter.tokeniser.Tokeniser;

public final class Parser {
    public static Modl parseModl(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        LinkedList<Token> tokens = Tokeniser.tokenise(s);
        Either<ModlPrimitive, List<ModlStructure>> parsed = Parser.parse(new TokenStream(tokens));
        return new Modl(parsed);
    }

    private static Either<ModlPrimitive, List<ModlStructure>> parse(@NonNull TokenStream s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        ModlPrimitive rootPrimitive = Parser.parsePrimitive(s);
        if (rootPrimitive != null) {
            return API.Left((Object)rootPrimitive);
        }
        return API.Right(Parser.parseStructures(s));
    }

    private static ModlPrimitive parsePrimitive(@NonNull TokenStream s) {
        ModlPrimitive result;
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Token tok = s.next();
        switch (tok.getType()) {
            case LPAREN: 
            case RPAREN: 
            case LBRACKET: 
            case RBRACKET: 
            case EQUALS: {
                if (s.isEmpty()) {
                    throw new ParserException(String.format("Unexpected token: %s", tok));
                }
                s.pushback(tok);
                return null;
            }
            case NULL: {
                result = ModlBoolNull.MODL_NULL;
                break;
            }
            case TRUE: {
                result = ModlBoolNull.MODL_TRUE;
                break;
            }
            case FALSE: {
                result = ModlBoolNull.MODL_FALSE;
                break;
            }
            case QUOTED: {
                result = new ModlQuoted((String)tok.getValue());
                break;
            }
            case STRING: {
                result = new ModlString((String)tok.getValue());
                break;
            }
            case INTEGER: {
                result = new ModlInteger((Integer)tok.getValue());
                break;
            }
            case FLOAT: {
                result = new ModlFloat(((Float)tok.getValue()).floatValue());
                break;
            }
            default: {
                throw new ParserException(String.format("Unknown token type in: %s", tok));
            }
        }
        Token peek = s.peek();
        if (peek != null && peek.getType() == TokenType.STRUCT_SEP) {
            throw new ParserException("Only one primitive is allowed at the root.");
        }
        if (peek != null && (peek.getType() == TokenType.LPAREN || peek.getType() == TokenType.LBRACKET || peek.getType() == TokenType.EQUALS)) {
            s.pushback(tok);
            return null;
        }
        if (peek != null) {
            throw new ParserException(String.format("Unexpected token: %s", peek));
        }
        return result;
    }

    private static List<ModlStructure> parseStructures(@NonNull TokenStream s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        ArrayList<ModlStructure> result = new ArrayList<ModlStructure>();
        while (!s.isEmpty()) {
            result.add((ModlStructure)((Object)Parser.parseModlValue(s)));
            Token maybeStructSep = s.next();
            if (maybeStructSep == null || maybeStructSep.getType() == TokenType.STRUCT_SEP) continue;
            throw new ParserException(String.format("Expected ';' near %s", maybeStructSep));
        }
        return result;
    }

    private static ModlMap parseModlMap(@NonNull TokenStream s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Token firstToken = s.next();
        ArrayList<ModlPair> mapEntries = new ArrayList<ModlPair>();
        while (!s.isEmpty()) {
            Token peek = s.peek();
            if (peek != null && peek.getType() == TokenType.RPAREN) {
                s.next();
                break;
            }
            ModlValue mp = Parser.parseModlValue(s);
            mapEntries.add((ModlPair)mp);
            peek = s.peek();
            if (peek != null) {
                if (peek.getType() == TokenType.RPAREN) {
                    s.next();
                    break;
                }
                if (peek.getType() != TokenType.STRUCT_SEP) continue;
                s.next();
                peek = s.peek();
                if (peek == null || peek.getType() != TokenType.RPAREN) continue;
                throw new ParserException(String.format("Unexpected ; before ] at %s", peek));
            }
            throw new ParserException(String.format("Expected ')' near %s", firstToken));
        }
        return new ModlMap(mapEntries);
    }

    private static ModlArray parseModlArray(@NonNull TokenStream s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Token firstToken = s.next();
        ArrayList<ModlValue> arrayEntries = new ArrayList<ModlValue>();
        while (!s.isEmpty()) {
            Token peek = s.peek();
            if (peek != null && peek.getType() == TokenType.RBRACKET) {
                s.next();
                break;
            }
            ModlValue ms = Parser.parseModlValue(s);
            arrayEntries.add(ms);
            peek = s.peek();
            if (peek != null) {
                if (peek.getType() == TokenType.RBRACKET) {
                    s.next();
                    break;
                }
                if (peek.getType() != TokenType.STRUCT_SEP) continue;
                s.next();
                peek = s.peek();
                if (peek == null || peek.getType() != TokenType.RBRACKET) continue;
                throw new ParserException(String.format("Unexpected ; before ] at %s", peek));
            }
            throw new ParserException(String.format("Expected ']' near %s", firstToken));
        }
        return new ModlArray(arrayEntries);
    }

    private static ModlValue parseModlValue(@NonNull TokenStream s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Token firstToken = s.next();
        if (firstToken.getType() == TokenType.LBRACKET) {
            s.pushback(firstToken);
            return Parser.parseModlArray(s);
        }
        if (firstToken.getType() == TokenType.LPAREN) {
            s.pushback(firstToken);
            return Parser.parseModlMap(s);
        }
        if (firstToken.getType() == TokenType.STRING || firstToken.getType() == TokenType.QUOTED) {
            Token peek = s.peek();
            String key = (String)firstToken.getValue();
            if (peek != null && peek.getType() == TokenType.EQUALS) {
                s.next();
                return new ModlPair(key, (ModlStructure)((Object)Parser.parsePairValue(s)));
            }
            if (peek != null && (peek.getType() == TokenType.LBRACKET || peek.getType() == TokenType.LPAREN)) {
                return new ModlPair(key, (ModlStructure)((Object)Parser.parsePairValue(s)));
            }
            if (peek == null || peek.getType() == TokenType.STRUCT_SEP || peek.getType() == TokenType.RPAREN || peek.getType() == TokenType.RBRACKET) {
                if (firstToken.getType() == TokenType.STRING) {
                    return new ModlString((String)firstToken.getValue());
                }
                return new ModlQuoted((String)firstToken.getValue());
            }
            throw new ParserException(String.format("Unexpected token: '%s'", firstToken));
        }
        if (firstToken.getType() == TokenType.INTEGER) {
            return new ModlInteger((Integer)firstToken.getValue());
        }
        if (firstToken.getType() == TokenType.FLOAT) {
            return new ModlFloat(((Float)firstToken.getValue()).floatValue());
        }
        if (firstToken.getType() == TokenType.NULL) {
            return ModlBoolNull.MODL_NULL;
        }
        if (firstToken.getType() == TokenType.TRUE) {
            return ModlBoolNull.MODL_TRUE;
        }
        if (firstToken.getType() == TokenType.FALSE) {
            return ModlBoolNull.MODL_FALSE;
        }
        s.pushback(firstToken);
        ModlPrimitive maybePrimitive = Parser.parsePrimitive(s);
        if (maybePrimitive != null) {
            return maybePrimitive;
        }
        throw new ParserException(String.format("Unexpected token: '%s'", firstToken));
    }

    private static ModlValue parsePairValue(@NonNull TokenStream s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Token firstToken = s.next();
        if (firstToken.getType() == TokenType.LBRACKET) {
            s.pushback(firstToken);
            return Parser.parseModlArray(s);
        }
        if (firstToken.getType() == TokenType.LPAREN) {
            s.pushback(firstToken);
            return Parser.parseModlMap(s);
        }
        if (firstToken.getType() == TokenType.STRING || firstToken.getType() == TokenType.QUOTED) {
            Token peek = s.peek();
            if (peek != null && peek.getType() == TokenType.EQUALS) {
                throw new ParserException(String.format("Unexpected token: '%s'", firstToken));
            }
            if (peek != null && (peek.getType() == TokenType.LBRACKET || peek.getType() == TokenType.LPAREN)) {
                throw new ParserException(String.format("Unexpected token: '%s'", firstToken));
            }
            if (peek == null || peek.getType() == TokenType.STRUCT_SEP || peek.getType() == TokenType.RPAREN || peek.getType() == TokenType.RBRACKET) {
                if (firstToken.getType() == TokenType.STRING) {
                    return new ModlString((String)firstToken.getValue());
                }
                return new ModlQuoted((String)firstToken.getValue());
            }
            throw new ParserException(String.format("Unexpected token: '%s'", firstToken));
        }
        if (firstToken.getType() == TokenType.INTEGER) {
            return new ModlInteger((Integer)firstToken.getValue());
        }
        if (firstToken.getType() == TokenType.FLOAT) {
            return new ModlFloat(((Float)firstToken.getValue()).floatValue());
        }
        if (firstToken.getType() == TokenType.NULL) {
            return ModlBoolNull.MODL_NULL;
        }
        if (firstToken.getType() == TokenType.TRUE) {
            return ModlBoolNull.MODL_TRUE;
        }
        if (firstToken.getType() == TokenType.FALSE) {
            return ModlBoolNull.MODL_FALSE;
        }
        s.pushback(firstToken);
        ModlPrimitive maybePrimitive = Parser.parsePrimitive(s);
        if (maybePrimitive != null) {
            return maybePrimitive;
        }
        throw new ParserException(String.format("Unexpected token: '%s'", firstToken));
    }

    private Parser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

