/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import lombok.NonNull;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import uk.modl.interpreter.InterpreterVisitor;
import uk.modl.model.Modl;
import uk.modl.parser.Parser;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.transforms.JacksonJsonNodeTransform;
import uk.modl.transforms.TransformationContext;

public class Interpreter {
    private final Parser parser = new Parser();
    private final InterpreterVisitor interpreterVisitor = new InterpreterVisitor();

    public Modl interpret(String modlString) {
        TransformationContext ctx = TransformationContext.emptyCtx();
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return (Modl)interpreted._2;
    }

    public JsonNode interpretToJsonObject(String modlString) {
        TransformationContext ctx = TransformationContext.emptyCtx();
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
    }

    public String interpretToJsonString(String modlString) throws JsonProcessingException {
        JsonNode jsonNode = this.interpretToJsonObject(modlString);
        return new ObjectMapper().writeValueAsString((Object)jsonNode);
    }

    public String interpretToPrettyJsonString(String modlString) throws JsonProcessingException {
        JsonNode jsonNode = this.interpretToJsonObject(modlString);
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
    }

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, @NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return (Tuple2)Option.of((Object)input).map(s -> this.parse(ctx, (String)s)).map(modl -> this.apply(ctx, (Modl)modl)).get();
    }

    public Modl parse(TransformationContext ctx, @NonNull String modlString) {
        if (modlString == null) {
            throw new NullPointerException("modlString is marked non-null but is null");
        }
        try {
            return this.parser.apply(modlString, ctx.getAncestry());
        }
        catch (InterpreterError e) {
            throw e;
        }
        catch (ParseCancellationException e) {
            throw new InterpreterError("Parser Error: " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw new InterpreterError("Interpreter Error: " + e.getMessage());
        }
    }

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, @NonNull Modl modl) {
        if (modl == null) {
            throw new NullPointerException("modl is marked non-null but is null");
        }
        return (Tuple2)Option.of((Object)modl).map(m -> this.interpreterVisitor.apply(ctx, (Modl)m)).get();
    }
}

