/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.ancestry.Ancestry;
import uk.modl.model.Modl;
import uk.modl.parser.ModlParsedVisitor;
import uk.modl.parser.antlr.MODLLexer;
import uk.modl.parser.antlr.MODLParser;
import uk.modl.parser.errors.ThrowingErrorListener;

public class Parser {
    private static final Logger log = LogManager.getLogger(Parser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Modl apply(String input, Ancestry ancestry, long timeoutMilliseconds) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
            MODLLexer lexer = new MODLLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            MODLParser parser = new MODLParser((TokenStream)tokens);
            parser.setBuildParseTree(true);
            lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            AtomicReference taskThread = new AtomicReference();
            AtomicReference taskException = new AtomicReference();
            AtomicReference modlCtx = new AtomicReference();
            try {
                long start = System.currentTimeMillis();
                new Thread(() -> {
                    try {
                        taskThread.set(Thread.currentThread());
                        modlCtx.set(parser.modl());
                    }
                    catch (Exception e) {
                        taskException.set(e);
                    }
                }).start();
                long now = System.currentTimeMillis();
                while (taskException.get() == null && modlCtx.get() == null && now - start < timeoutMilliseconds) {
                    Thread.sleep(10L);
                    now = System.currentTimeMillis();
                }
            }
            finally {
                ((Thread)taskThread.get()).stop();
            }
            Exception threadEx = (Exception)taskException.get();
            if (threadEx != null) {
                if (threadEx instanceof RuntimeException) {
                    throw (RuntimeException)threadEx;
                }
                throw new RuntimeException(threadEx);
            }
            if (modlCtx.get() != null) {
                return new ModlParsedVisitor((MODLParser.ModlContext)((Object)modlCtx.get()), ancestry).getModl();
            }
            throw new TimeoutException();
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

